/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.moves.MoveSwapScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import party.extras.cobblemon.client.AbilityRenderContext;
import party.extras.cobblemon.client.MoveSwapCategoryTracker;
import party.extras.cobblemon.client.tooltip.MoveTooltipHelper;

@Mixin(value={MoveSwapScreen.MoveSlot.class}, remap=false)
public abstract class MoveSwapSlotMixin {
    @Shadow
    @Final
    private MoveTemplate move;
    @Unique
    private boolean partyExtras$moveRenderPushed = false;

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (MoveSwapCategoryTracker.isSeparatorSlot(this)) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (this.move != null && MoveSwapCategoryTracker.isDisabledMove(this.move)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void onRenderHead(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo ci) {
        if (MoveSwapCategoryTracker.isActive() && MoveSwapCategoryTracker.isSeparator(index)) {
            this.renderSeparator(context, index, y, x, entryWidth, entryHeight);
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, remap=true)
    private void onRenderStart(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo ci) {
        if (this.move != null && !MoveSwapCategoryTracker.isSeparator(index)) {
            AbilityRenderContext.pushMoveRender();
            this.partyExtras$moveRenderPushed = true;
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")}, remap=true)
    private void onRenderReturn(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo ci) {
        if (this.partyExtras$moveRenderPushed) {
            AbilityRenderContext.popMoveRender();
            this.partyExtras$moveRenderPushed = false;
        }
        if (this.move != null && MoveSwapCategoryTracker.isDisabledMove(this.move)) {
            context.method_25294(x, y, x + entryWidth, y + entryHeight, -1879048192);
            int level = MoveSwapCategoryTracker.getFutureMoveLevel(this.move.getName());
            if (level > 0) {
                class_327 font = class_310.method_1551().field_1772;
                String levelText = "Lv. " + level;
                class_4587 pose = context.method_51448();
                pose.method_22903();
                float scale = 0.85f;
                pose.method_22905(scale, scale, 1.0f);
                int scaledTextWidth = (int)((float)font.method_1727(levelText) * scale);
                int textX = (int)((float)(x + entryWidth - scaledTextWidth - 6) / scale);
                int textY = (int)((float)(y + 4) / scale);
                int bgX1 = textX - 2;
                int bgY1 = textY - 1;
                int bgX2 = textX + font.method_1727(levelText) + 2;
                int bgY2 = textY + 9;
                context.method_25294(bgX1, bgY1, bgX2, bgY2, -1342177280);
                context.method_25294(bgX1, bgY1, bgX2, bgY1 + 1, 0x50FFFFFF);
                context.method_25294(bgX1, bgY1, bgX1 + 1, bgY2, 0x50FFFFFF);
                context.method_51439(font, (class_2561)class_2561.method_43470((String)levelText), textX, textY, 0xFFFFFF, false);
                pose.method_22909();
            }
        }
        if (hovered && this.move != null && !MoveSwapCategoryTracker.isSeparator(index) && !MoveSwapCategoryTracker.isMouseOverDropdown(mouseX, mouseY)) {
            boolean preferLeft = mouseX <= x + entryWidth / 2;
            MoveTooltipHelper.setHoveredMove(this.move, mouseX, mouseY, preferLeft);
        }
    }

    @Unique
    private void renderSeparator(class_332 context, int index, int y, int x, int entryWidth, int entryHeight) {
        String label = MoveSwapCategoryTracker.getSeparatorLabel(index);
        int color = MoveSwapCategoryTracker.getSeparatorColor(index);
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(label);
        int tweakedY = y + 2;
        int separatorHeight = 12;
        int bgDark = Integer.MIN_VALUE;
        int bgLight = 0x40000000;
        context.method_25294(x - 9, tweakedY, x + entryWidth, tweakedY + separatorHeight, bgDark);
        context.method_25294(x - 9, tweakedY, x + entryWidth, tweakedY + 1, bgLight);
        context.method_25294(x - 9, tweakedY + separatorHeight - 1, x + entryWidth, tweakedY + separatorHeight, 0x60000000);
        context.method_25294(x - 9, tweakedY + 1, x - 5, tweakedY + separatorHeight - 1, color | 0xFF000000);
        context.method_25294(x - 5, tweakedY + 1, x - 4, tweakedY + separatorHeight - 1, color & 0xFFFFFF | Integer.MIN_VALUE);
        int textX = x + (entryWidth - textWidth) / 2 - 4;
        int textY = tweakedY + (separatorHeight - 8) / 2 + 1;
        class_4587 pose = context.method_51448();
        pose.method_22903();
        pose.method_22905(0.9f, 0.9f, 1.0f);
        context.method_51439(font, (class_2561)class_2561.method_43470((String)label), (int)((float)textX / 0.9f), (int)((float)textY / 0.9f), -1, true);
        pose.method_22909();
    }
}

