/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.client.gui.summary.widgets.common.SummaryScrollList;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.moves.MoveSwapScreen;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import party.extras.client.MoveSwapFilterAccess;
import party.extras.cobblemon.client.MoveSwapCategoryTracker;
import party.extras.cobblemon.client.tooltip.MoveTooltipHelper;

@Mixin(value={SummaryScrollList.class}, remap=false)
public abstract class MoveSwapScreenMixin {
    @Shadow
    @Final
    private int listX;
    @Shadow
    @Final
    private int listY;
    private static final int SLOT_HEIGHT = 18;
    private static final int SLOT_SPACING = 3;
    private static final int HEADER_HEIGHT = 8;
    private static final int LIST_WIDTH = 91;
    private static final int FILTER_BUTTON_HEIGHT = 10;
    private static final int FILTER_ITEM_HEIGHT = 9;
    private static final int FILTER_Y_OFFSET = -10;
    private static final boolean FILTER_ENABLED = false;

    @Inject(method={"renderWidget"}, at={@At(value="RETURN")}, remap=true, require=0)
    private void onRenderWidget(class_332 context, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        MoveSwapScreenMixin thisObj = this;
        if (!(thisObj instanceof MoveSwapScreen)) {
            return;
        }
        if (MoveSwapCategoryTracker.isActive()) {
            this.renderCategoryHeaders(context);
        }
        MoveSwapCategoryTracker.setFilterOpen(false);
        MoveSwapCategoryTracker.clearDropdownBounds();
        MoveTooltipHelper.renderDeferredTooltip(context);
    }

    private void renderCategoryHeaders(class_332 context) {
        List<MoveSwapCategoryTracker.CategoryInfo> categories = MoveSwapCategoryTracker.getCategories();
        if (categories.isEmpty()) {
            return;
        }
        try {
            SummaryScrollList screen = (SummaryScrollList)this;
            double scrollAmount = screen.method_25341();
            class_4587 pose = context.method_51448();
            for (MoveSwapCategoryTracker.CategoryInfo category : categories) {
                int entryHeight = 21;
                int entryTop = this.listY + category.startIndex * entryHeight - (int)scrollAmount;
                int headerY = entryTop - 8 - 2;
                if (headerY < this.listY - 8 || headerY >= this.listY + 120) continue;
                context.method_25294(this.listX, headerY, this.listX + 91, headerY + 8, -1879048192);
                context.method_25294(this.listX, headerY, this.listX + 91, headerY + 1, 0x40FFFFFF);
                context.method_25294(this.listX, headerY + 8 - 1, this.listX + 91, headerY + 8, 0x60000000);
                context.method_25294(this.listX, headerY + 1, this.listX + 3, headerY + 8 - 1, 0xFF000000 | category.color);
                context.method_25294(this.listX + 3, headerY + 1, this.listX + 4, headerY + 8 - 1, category.color & 0xFFFFFF | 0x60000000);
                pose.method_22903();
                pose.method_46416(0.0f, 0.0f, 200.0f);
                pose.method_22905(0.85f, 0.85f, 1.0f);
                context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)category.name.toUpperCase()), (int)((float)(this.listX + 6) / 0.85f), (int)((float)(headerY + 1) / 0.85f), -1, true);
                pose.method_22909();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderFilterControl(class_332 context, int mouseX, int mouseY) {
        int buttonY;
        MoveSwapScreenMixin thisObj = this;
        if (!(thisObj instanceof MoveSwapScreen)) {
            return;
        }
        String label = "Type: " + MoveSwapCategoryTracker.getSelectedTypeLabel();
        int buttonWidth = this.getFilterButtonWidth(label);
        int buttonX = this.listX + 91 - buttonWidth + 16;
        boolean hovered = this.isMouseOver(mouseX, mouseY, buttonX, buttonY = this.listY + -10, buttonWidth, 10);
        int bgColor = hovered ? -580496094 : -866827247;
        int borderColor = hovered ? -2051222 : -4617142;
        context.method_25294(buttonX, buttonY, buttonX + buttonWidth, buttonY + 10, bgColor);
        context.method_25294(buttonX, buttonY, buttonX + buttonWidth, buttonY + 1, borderColor);
        context.method_25294(buttonX, buttonY + 10 - 1, buttonX + buttonWidth, buttonY + 10, borderColor);
        context.method_25294(buttonX, buttonY, buttonX + 1, buttonY + 10, borderColor);
        context.method_25294(buttonX + buttonWidth - 1, buttonY, buttonX + buttonWidth, buttonY + 10, borderColor);
        class_4587 pose = context.method_51448();
        pose.method_22903();
        pose.method_22905(0.7f, 0.7f, 1.0f);
        int textWidth = (int)((float)class_310.method_1551().field_1772.method_1727(label) * 0.7f);
        int textHeight = 5;
        int textX = buttonX + (buttonWidth - textWidth) / 2;
        int textY = buttonY + (10 - textHeight) / 2;
        context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)label), (int)((float)textX / 0.7f), (int)((float)textY / 0.7f), 0xFFFFFF, true);
        pose.method_22909();
        if (MoveSwapCategoryTracker.isFilterOpen()) {
            this.renderFilterDropdown(context, mouseX, mouseY, buttonX, buttonY + 10 + 2, buttonWidth);
        } else {
            MoveSwapCategoryTracker.clearDropdownBounds();
        }
    }

    private void renderFilterDropdown(class_332 context, int mouseX, int mouseY, int startX, int startY, int dropdownWidth) {
        List<String> options = MoveSwapCategoryTracker.getTypeFilters();
        int dropdownHeight = options.size() * 9;
        MoveSwapCategoryTracker.setDropdownBounds(startX, startY, dropdownWidth, dropdownHeight);
        class_4587 pose = context.method_51448();
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 300.0f);
        context.method_25294(startX, startY, startX + dropdownWidth, startY + dropdownHeight, -869064192);
        context.method_25294(startX, startY, startX + dropdownWidth, startY + 1, -2643350);
        context.method_25294(startX, startY + dropdownHeight - 1, startX + dropdownWidth, startY + dropdownHeight, -7710166);
        for (int i = 0; i < options.size(); ++i) {
            int itemY = startY + i * 9;
            boolean hovered = this.isMouseOver(mouseX, mouseY, startX, itemY, dropdownWidth, 9);
            if (hovered) {
                context.method_25294(startX, itemY, startX + dropdownWidth, itemY + 9, 1345528064);
            }
            String label = "all".equalsIgnoreCase(options.get(i)) ? "All" : this.capitalize(options.get(i));
            pose.method_22903();
            pose.method_22905(0.7f, 0.7f, 1.0f);
            context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)label), (int)((float)(startX + 3) / 0.7f), (int)((float)(itemY + 1) / 0.7f), -1, false);
            pose.method_22909();
        }
        pose.method_22909();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true, remap=true, require=0)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        MoveSwapScreenMixin thisObj = this;
        if (!(thisObj instanceof MoveSwapScreen)) {
            return;
        }
    }

    private boolean handleFilterClick(int mouseX, int mouseY, int button) {
        int buttonY;
        if (button != 0) {
            return false;
        }
        String label = "Type: " + MoveSwapCategoryTracker.getSelectedTypeLabel();
        int buttonWidth = this.getFilterButtonWidth(label);
        int buttonX = this.listX + 91 - buttonWidth + 16;
        if (this.isMouseOver(mouseX, mouseY, buttonX, buttonY = this.listY + -10, buttonWidth, 10)) {
            MoveSwapCategoryTracker.toggleFilterOpen();
            return true;
        }
        if (MoveSwapCategoryTracker.isFilterOpen()) {
            int dropdownX = buttonX;
            int dropdownY = buttonY + 10 + 2;
            List<String> options = MoveSwapCategoryTracker.getTypeFilters();
            int dropdownHeight = options.size() * 9;
            for (int i = 0; i < options.size(); ++i) {
                int itemY = dropdownY + i * 9;
                if (!this.isMouseOver(mouseX, mouseY, dropdownX, itemY, buttonWidth, 9)) continue;
                MoveSwapCategoryTracker.setSelectedType(options.get(i));
                MoveSwapCategoryTracker.setFilterOpen(false);
                this.refreshMoveList();
                return true;
            }
            if (this.isMouseOver(mouseX, mouseY, dropdownX, dropdownY, buttonWidth, dropdownHeight)) {
                return true;
            }
            MoveSwapCategoryTracker.setFilterOpen(false);
        }
        return false;
    }

    private void refreshMoveList() {
        MoveSwapScreenMixin thisObj = this;
        if (thisObj instanceof MoveSwapFilterAccess) {
            MoveSwapFilterAccess access = (MoveSwapFilterAccess)((Object)thisObj);
            access.partyExtras$refreshEntries();
        }
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private int getFilterButtonWidth(String label) {
        int labelWidth;
        int widest = labelWidth = (int)((float)class_310.method_1551().field_1772.method_1727(label) * 0.7f);
        for (String option : MoveSwapCategoryTracker.getTypeFilters()) {
            String optionLabel = "all".equalsIgnoreCase(option) ? "All" : this.capitalize(option);
            int optionWidth = (int)((float)class_310.method_1551().field_1772.method_1727(optionLabel) * 0.7f);
            if (optionWidth <= widest) continue;
            widest = optionWidth;
        }
        return Math.max(32, widest + 10);
    }

    private String capitalize(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }
}

