/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.api.abilities.AbilityPool;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.client.gui.summary.widgets.SoundlessWidget;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.info.InfoWidget;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import party.extras.cobblemon.client.AbilityRenderContext;
import party.extras.cobblemon.client.LearnsetLoader;

@Mixin(value={InfoWidget.class}, remap=false)
public abstract class InfoWidgetMixin
extends SoundlessWidget {
    @Shadow
    @Final
    private Pokemon pokemon;
    @Unique
    private Boolean cachedIsHidden = null;
    @Unique
    private String cachedAbilityName = null;
    @Unique
    private String cachedNatureName = null;
    @Unique
    private String cachedOTName = null;
    @Unique
    private String cachedSpeciesName = null;
    @Unique
    private Integer cachedPrimaryTypeColor = null;
    @Unique
    private String cachedDexNumber = null;

    protected InfoWidgetMixin(int pX, int pY, int pWidth, int pHeight, class_2561 message) {
        super(pX, pY, pWidth, pHeight, message);
    }

    @Inject(method={"renderWidget"}, at={@At(value="HEAD")}, remap=true)
    private void onRenderStart(class_332 context, int pMouseX, int pMouseY, float pPartialTicks, CallbackInfo ci) {
        try {
            AbilityRenderContext.pushInfoWidgetRender();
            if (this.cachedIsHidden == null || this.cachedAbilityName == null) {
                this.cachedIsHidden = this.checkIfHiddenAbility();
                if (this.pokemon != null && this.pokemon.getAbility() != null) {
                    this.cachedAbilityName = class_2561.method_43471((String)this.pokemon.getAbility().getDisplayName()).getString();
                }
            }
            if (this.cachedNatureName == null && this.pokemon != null && this.pokemon.getNature() != null) {
                this.cachedNatureName = class_2561.method_43471((String)this.pokemon.getNature().getDisplayName()).getString();
            }
            if (this.cachedOTName == null && this.pokemon != null) {
                String otName = this.pokemon.getOriginalTrainerName();
                if (otName != null && !otName.isEmpty()) {
                    this.cachedOTName = otName;
                } else if (this.pokemon.getOriginalTrainer() != null) {
                    this.cachedOTName = this.pokemon.getOriginalTrainer().toString().substring(0, 15) + "...";
                }
            }
            if ((this.cachedSpeciesName == null || this.cachedPrimaryTypeColor == null) && this.pokemon != null && this.pokemon.getSpecies() != null) {
                this.cachedSpeciesName = this.pokemon.getSpecies().getTranslatedName().getString();
                this.cachedPrimaryTypeColor = this.pokemon.getPrimaryType().getHue();
            }
            if (this.cachedDexNumber == null && this.pokemon != null && this.pokemon.getSpecies() != null) {
                this.cachedDexNumber = String.format("%04d", this.pokemon.getSpecies().getNationalPokedexNumber());
            }
            AbilityRenderContext.setAbility(this.cachedAbilityName, this.cachedIsHidden);
            AbilityRenderContext.setNature(this.cachedNatureName);
            AbilityRenderContext.setOT(this.cachedOTName);
            AbilityRenderContext.setSpecies(this.cachedSpeciesName, this.cachedPrimaryTypeColor);
            AbilityRenderContext.setDexNumber(this.cachedDexNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"renderWidget"}, at={@At(value="RETURN")}, remap=true)
    private void onRenderEnd(class_332 context, int pMouseX, int pMouseY, float pPartialTicks, CallbackInfo ci) {
        try {
            if (this.cachedIsHidden == null) {
                this.cachedIsHidden = this.checkIfHiddenAbility();
            }
            if (this.cachedIsHidden.booleanValue()) {
                int abilityRowY = this.method_46427() + 75 + 6;
                int hIndicatorX = this.method_46426() + 48;
                class_4587 pose = context.method_51448();
                pose.method_22903();
                float scale = 0.65f;
                pose.method_22905(scale, scale, 1.0f);
                int scaledX = (int)((float)hIndicatorX / scale);
                int scaledY = (int)((float)abilityRowY / scale);
                int boxPadding = 3;
                int boxWidth = class_310.method_1551().field_1772.method_1727("H") + boxPadding * 2;
                int boxHeight = 10;
                context.method_25294(scaledX - boxPadding + 1, scaledY - 1, scaledX + boxWidth - boxPadding - 2, scaledY + boxHeight - 2, -1073741824);
                context.method_25294(scaledX - boxPadding + 1, scaledY - 1, scaledX + boxWidth - boxPadding - 2, scaledY, 1621754111);
                context.method_25294(scaledX - boxPadding + 1, scaledY - 1, scaledX - boxPadding + 2, scaledY + boxHeight - 2, 1621754111);
                class_5250 hIndicator = class_2561.method_43470((String)"H");
                context.method_51439(class_310.method_1551().field_1772, (class_2561)hIndicator, scaledX, scaledY, 0xDD88FF, false);
                pose.method_22909();
            }
            this.renderEggGroupAndHappiness(context);
            AbilityRenderContext.popInfoWidgetRender();
            AbilityRenderContext.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void renderEggGroupAndHappiness(class_332 context) {
        try {
            if (this.pokemon == null) {
                return;
            }
            class_4587 pose = context.method_51448();
            class_327 font = class_310.method_1551().field_1772;
            int startX = this.method_46426() + 8;
            int startY = this.method_46427() + 125;
            float smallScale = 0.6f;
            pose.method_22903();
            pose.method_22905(smallScale, smallScale, 1.0f);
            int scaledX = (int)((float)startX / smallScale);
            int scaledY = (int)((float)startY / smallScale);
            try {
                int happiness = this.pokemon.getFriendship();
                context.method_51433(font, "Happiness:", scaledX, scaledY, -5592406, true);
                int happinessColor = happiness >= 220 ? -11141291 : (happiness >= 160 ? -171 : (happiness >= 100 ? -21931 : -43691));
                String happinessText = happiness + "/255";
                context.method_51433(font, happinessText, scaledX + font.method_1727("Happiness: "), scaledY, happinessColor, true);
            }
            catch (Exception happiness) {
                // empty catch block
            }
            try {
                LearnsetLoader.CachedSpeciesData speciesData;
                Set eggGroups = this.pokemon.getForm().getEggGroups();
                ArrayList<String> eggGroupNames = new ArrayList<String>();
                if (eggGroups != null && eggGroups.iterator().hasNext()) {
                    for (Object eggGroup : eggGroups) {
                        try {
                            Method method = eggGroup.getClass().getMethod("getShowdownID", new Class[0]);
                            eggGroupNames.add((String)method.invoke(eggGroup, new Object[0]));
                        }
                        catch (Exception e) {
                            eggGroupNames.add(eggGroup.toString());
                        }
                    }
                }
                if (eggGroupNames.isEmpty() && (speciesData = LearnsetLoader.getSpeciesData(this.pokemon)) != null && !speciesData.eggGroups.isEmpty()) {
                    eggGroupNames.addAll(speciesData.eggGroups);
                }
                if (!eggGroupNames.isEmpty()) {
                    int eggGroupY = scaledY + 12;
                    context.method_51433(font, "Egg Group:", scaledX, eggGroupY, -5592406, true);
                    int lineOffset = 0;
                    for (String eggGroupName : eggGroupNames) {
                        eggGroupName = this.abbreviateEggGroup(eggGroupName);
                        context.method_51433(font, eggGroupName, scaledX + font.method_1727("Egg Group: "), eggGroupY + lineOffset, -1, true);
                        lineOffset += 10;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            pose.method_22909();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private boolean checkIfHiddenAbility() {
        try {
            if (this.pokemon == null || this.pokemon.getAbility() == null) {
                return false;
            }
            String currentAbilityName = this.pokemon.getAbility().getTemplate().getName();
            AbilityPool abilityPool = this.pokemon.getForm().getAbilities();
            Method getMappingMethod = abilityPool.getClass().getMethod("getMapping", new Class[0]);
            Map mapping = (Map)getMappingMethod.invoke((Object)abilityPool, new Object[0]);
            for (Map.Entry entry : mapping.entrySet()) {
                for (PotentialAbility potential : (List)entry.getValue()) {
                    if (!potential.getTemplate().getName().equals(currentAbilityName)) continue;
                    return potential instanceof HiddenAbility;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Unique
    private String abbreviateEggGroup(String eggGroupName) {
        if (eggGroupName == null) {
            return "";
        }
        return switch (eggGroupName) {
            case "Human-Like", "Humanlike", "Human Like" -> "Human";
            case "Amorphous" -> "Amorph";
            case "Undiscovered" -> "???";
            default -> eggGroupName;
        };
    }
}

