/*
 * Decompiled with CFR 0.152.
 */
package party.extras.mixin;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"com.cobblemon.mod.common.client.render.RenderHelperKt"}, remap=false)
public class DrawScaledTextMixin {
    @Unique
    private static final int HIDDEN_ABILITY_COLOR = 0xDD88FF;
    @Unique
    private static final int REGULAR_ABILITY_COLOR = 0x55AAFF;
    @Unique
    private static final int NATURE_COLOR = 0xFFFF00;
    @Unique
    private static final int OT_COLOR = 0x55FF55;
    @Unique
    private static final int DEX_NUMBER_COLOR = 0x55FFFF;
    @Unique
    private static Class<?> abilityRenderContextClass = null;
    @Unique
    private static boolean reflectionInitialized = false;
    @Unique
    private static Field currentAbilityNameField = null;
    @Unique
    private static Field currentAbilityIsHiddenField = null;
    @Unique
    private static Field currentNatureNameField = null;
    @Unique
    private static Field currentOTNameField = null;
    @Unique
    private static Field currentSpeciesNameField = null;
    @Unique
    private static Field currentPrimaryTypeColorField = null;
    @Unique
    private static Field currentDexNumberField = null;
    @Unique
    private static Field currentMoveRenderDepthField = null;
    @Unique
    private static Field currentInfoWidgetRenderDepthField = null;
    @Unique
    private static Class<?> movesClass = null;
    @Unique
    private static Object movesInstance = null;
    @Unique
    private static Method movesLookupMethod = null;

    @Unique
    private static void initReflection() {
        if (reflectionInitialized) {
            return;
        }
        reflectionInitialized = true;
        try {
            abilityRenderContextClass = Class.forName("party.extras.cobblemon.client.AbilityRenderContext");
            currentAbilityNameField = abilityRenderContextClass.getField("currentAbilityName");
            currentAbilityIsHiddenField = abilityRenderContextClass.getField("currentAbilityIsHidden");
            currentNatureNameField = abilityRenderContextClass.getField("currentNatureName");
            currentOTNameField = abilityRenderContextClass.getField("currentOTName");
            currentSpeciesNameField = abilityRenderContextClass.getField("currentSpeciesName");
            currentPrimaryTypeColorField = abilityRenderContextClass.getField("currentPrimaryTypeColor");
            currentDexNumberField = abilityRenderContextClass.getField("currentDexNumber");
            currentMoveRenderDepthField = abilityRenderContextClass.getField("moveRenderDepth");
            currentInfoWidgetRenderDepthField = abilityRenderContextClass.getField("infoWidgetRenderDepth");
        }
        catch (Exception e) {
            reflectionInitialized = false;
        }
    }

    @Unique
    private static String getAbilityName() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentAbilityNameField == null) {
                return null;
            }
            return (String)currentAbilityNameField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private static Boolean getAbilityIsHidden() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentAbilityIsHiddenField == null) {
                return null;
            }
            return (Boolean)currentAbilityIsHiddenField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private static String getNatureName() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentNatureNameField == null) {
                return null;
            }
            return (String)currentNatureNameField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private static String getOTName() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentOTNameField == null) {
                return null;
            }
            return (String)currentOTNameField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private static String getSpeciesName() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentSpeciesNameField == null) {
                return null;
            }
            return (String)currentSpeciesNameField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private static Integer getPrimaryTypeColor() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentPrimaryTypeColorField == null) {
                return null;
            }
            return (Integer)currentPrimaryTypeColorField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private static String getDexNumber() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentDexNumberField == null) {
                return null;
            }
            return (String)currentDexNumberField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Unique
    private static boolean isMoveRenderActive() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentMoveRenderDepthField == null) {
                return false;
            }
            Integer depth = (Integer)currentMoveRenderDepthField.get(null);
            return depth != null && depth > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Unique
    private static boolean isInfoWidgetRenderActive() {
        try {
            DrawScaledTextMixin.initReflection();
            if (currentInfoWidgetRenderDepthField == null) {
                return false;
            }
            Integer depth = (Integer)currentInfoWidgetRenderDepthField.get(null);
            return depth != null && depth > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Unique
    private static boolean isMoveName(String textContent) {
        try {
            if (movesClass == null) {
                movesClass = Class.forName("com.cobblemon.mod.common.api.moves.Moves");
                movesInstance = movesClass.getField("INSTANCE").get(null);
                for (Method method : movesClass.getMethods()) {
                    String name;
                    if (method.getParameterCount() != 1 || method.getParameterTypes()[0] != String.class || !(name = method.getName()).equals("getByName") && !name.equals("getByNameOrNull") && !name.equals("get")) continue;
                    movesLookupMethod = method;
                    break;
                }
            }
            if (movesLookupMethod == null || movesInstance == null) {
                return false;
            }
            String raw = textContent.trim();
            String lowered = raw.toLowerCase();
            String normalized = lowered.replace(" ", "_");
            Object result = movesLookupMethod.invoke(movesInstance, normalized);
            if (result != null) {
                return true;
            }
            if (!normalized.equals(lowered)) {
                result = movesLookupMethod.invoke(movesInstance, lowered);
                return result != null;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Inject(method={"drawScaledText"}, at={@At(value="HEAD")})
    private static void onDrawScaledText(class_332 context, class_2960 font, class_5250 text, Number x, Number y, float scale, Number opacity, int maxCharacterWidth, int colour, boolean centered, boolean shadow, Integer pMouseX, Integer pMouseY, CallbackInfo ci) {
        try {
            if (text == null) {
                return;
            }
            String textContent = text.getString().trim();
            String textLower = textContent.toLowerCase();
            if (textContent.isEmpty() || textContent.length() > 50) {
                return;
            }
            String currentAbility = DrawScaledTextMixin.getAbilityName();
            Boolean isHidden = DrawScaledTextMixin.getAbilityIsHidden();
            if (currentAbility != null && textContent.equals(currentAbility)) {
                if (isHidden != null && isHidden.booleanValue()) {
                    text.method_10862(text.method_10866().method_36139(0xDD88FF));
                } else {
                    text.method_10862(text.method_10866().method_36139(0x55AAFF));
                }
                return;
            }
            String currentNature = DrawScaledTextMixin.getNatureName();
            if (currentNature != null && textContent.equals(currentNature)) {
                text.method_10862(text.method_10866().method_36139(0xFFFF00));
                return;
            }
            String currentOT = DrawScaledTextMixin.getOTName();
            if (currentOT != null && textContent.equals(currentOT)) {
                text.method_10862(text.method_10866().method_36139(0x55FF55));
                return;
            }
            String currentSpecies = DrawScaledTextMixin.getSpeciesName();
            Integer primaryTypeColor = DrawScaledTextMixin.getPrimaryTypeColor();
            if (currentSpecies != null && primaryTypeColor != null && textContent.equals(currentSpecies)) {
                text.method_10862(text.method_10866().method_36139(primaryTypeColor.intValue()));
                return;
            }
            String currentDexNumber = DrawScaledTextMixin.getDexNumber();
            if (currentDexNumber != null && textContent.equals(currentDexNumber)) {
                text.method_10862(text.method_10866().method_36139(0x55FFFF));
                return;
            }
            if (DrawScaledTextMixin.isMoveRenderActive() && DrawScaledTextMixin.isMoveName(textContent)) {
                return;
            }
            if (!DrawScaledTextMixin.isInfoWidgetRenderActive()) {
                return;
            }
            ElementalType matchedType = DrawScaledTextMixin.getTypeForText(textLower);
            if (matchedType != null) {
                int typeColor = matchedType.getHue();
                text.method_10862(text.method_10866().method_36139(typeColor));
                return;
            }
            if (textLower.contains("/")) {
                String[] typesLower = textLower.split("/");
                String[] typesOriginal = textContent.split("/");
                if (typesLower.length == 2) {
                    ElementalType firstType = DrawScaledTextMixin.getTypeForText(typesLower[0].trim());
                    ElementalType secondType = DrawScaledTextMixin.getTypeForText(typesLower[1].trim());
                    if (firstType != null && secondType != null) {
                        DrawScaledTextMixin.rebuildDualTypeComponent(text, typesOriginal[0], typesOriginal[1], firstType, secondType);
                    } else if (firstType != null) {
                        int typeColor = firstType.getHue();
                        text.method_10862(text.method_10866().method_36139(typeColor));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private static void rebuildDualTypeComponent(class_5250 text, String type1, String type2, ElementalType eleType1, ElementalType eleType2) {
        try {
            class_2583 baseStyle = text.method_10866();
            List existingSiblings = text.method_10855();
            if (existingSiblings.size() >= 2) {
                text.method_10862(baseStyle.method_36139(eleType1.getHue()));
                for (int i = 0; i < existingSiblings.size(); ++i) {
                    class_5250 mutableSibling;
                    String siblingText;
                    ElementalType siblingType;
                    class_2561 sibling = (class_2561)existingSiblings.get(i);
                    if (!(sibling instanceof class_5250) || (siblingType = DrawScaledTextMixin.getTypeForText(siblingText = (mutableSibling = (class_5250)sibling).getString().toLowerCase().trim())) == null) continue;
                    mutableSibling.method_10862(mutableSibling.method_10866().method_36139(siblingType.getHue()));
                }
            } else {
                text.method_10862(baseStyle.method_36139(eleType1.getHue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private static ElementalType getTypeForText(String textContent) {
        ElementalType[] allTypes;
        for (ElementalType type : allTypes = new ElementalType[]{ElementalTypes.INSTANCE.getWATER(), ElementalTypes.INSTANCE.getFIRE(), ElementalTypes.INSTANCE.getGRASS(), ElementalTypes.INSTANCE.getELECTRIC(), ElementalTypes.INSTANCE.getICE(), ElementalTypes.INSTANCE.getFIGHTING(), ElementalTypes.INSTANCE.getPOISON(), ElementalTypes.INSTANCE.getGROUND(), ElementalTypes.INSTANCE.getFLYING(), ElementalTypes.INSTANCE.getPSYCHIC(), ElementalTypes.INSTANCE.getBUG(), ElementalTypes.INSTANCE.getROCK(), ElementalTypes.INSTANCE.getGHOST(), ElementalTypes.INSTANCE.getDRAGON(), ElementalTypes.INSTANCE.getDARK(), ElementalTypes.INSTANCE.getSTEEL(), ElementalTypes.INSTANCE.getFAIRY(), ElementalTypes.INSTANCE.getNORMAL()}) {
            try {
                String displayName = DrawScaledTextMixin.getLocalizedTypeName(type);
                if (displayName != null && displayName.equalsIgnoreCase(textContent)) {
                    return type;
                }
                if (!type.getName().equalsIgnoreCase(textContent)) continue;
                return type;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Unique
    private static String getLocalizedTypeName(ElementalType type) {
        try {
            Object typeDisplayName = type.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)type, new Object[0]);
            return typeDisplayName.getClass().getMethod("getString", new Class[0]).invoke(typeDisplayName, new Object[0]).toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

