/*
 * Decompiled with CFR 0.152.
 */
package party.extras.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PartyExtrasConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "cobblemon_party_extras.json";
    private static PartyExtrasConfig INSTANCE;
    public boolean enableGuiShaders = false;
    public boolean showLevelUpMoves = true;
    public boolean showEggMoves = true;
    public boolean showTMMoves = true;
    public boolean showPartyTypeIcons = true;

    public static PartyExtrasConfig get() {
        if (INSTANCE == null) {
            PartyExtrasConfig.load();
        }
        return INSTANCE;
    }

    public static void load() {
        File configFile = PartyExtrasConfig.getConfigFile();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                INSTANCE = (PartyExtrasConfig)GSON.fromJson((Reader)reader, PartyExtrasConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new PartyExtrasConfig();
                }
            }
            catch (Exception e) {
                System.err.println("[PartyExtras] Failed to load config: " + e.getMessage());
                INSTANCE = new PartyExtrasConfig();
            }
        } else {
            INSTANCE = new PartyExtrasConfig();
            PartyExtrasConfig.save();
        }
    }

    public static void save() {
        if (INSTANCE == null) {
            INSTANCE = new PartyExtrasConfig();
        }
        File configFile = PartyExtrasConfig.getConfigFile();
        try {
            configFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (Exception e) {
            System.err.println("[PartyExtras] Failed to save config: " + e.getMessage());
        }
    }

    private static File getConfigFile() {
        Path configDir = Paths.get("config", new String[0]);
        return configDir.resolve(CONFIG_FILE).toFile();
    }

    public static boolean isGuiShadersEnabled() {
        return PartyExtrasConfig.get().enableGuiShaders;
    }
}

