/*
 * Decompiled with CFR 0.152.
 */
package party.extras.compat;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class RandomizerCompat {
    private static Boolean randomizerPresent = null;

    public static boolean isRandomizerPresent() {
        if (randomizerPresent == null) {
            try {
                Class.forName("cobblemon.randomizer.client.RandomizerClient");
                randomizerPresent = true;
            }
            catch (ClassNotFoundException e) {
                randomizerPresent = false;
            }
        }
        return randomizerPresent;
    }

    public static boolean hasRandomizedLearnset(Pokemon pokemon) {
        if (!RandomizerCompat.isRandomizerPresent() || pokemon == null) {
            return false;
        }
        try {
            String pokemonUUID = pokemon.getUuid().toString();
            Class<?> clientClass = Class.forName("cobblemon.randomizer.client.RandomizerClient");
            Method method = clientClass.getMethod("hasLearnsetMapping", String.class);
            return (Boolean)method.invoke(null, pokemonUUID);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getRandomizedMoveName(Pokemon pokemon, String originalMoveName) {
        if (!RandomizerCompat.isRandomizerPresent() || pokemon == null || originalMoveName == null) {
            return originalMoveName;
        }
        try {
            String pokemonUUID = pokemon.getUuid().toString();
            Class<?> clientClass = Class.forName("cobblemon.randomizer.client.RandomizerClient");
            Method method = clientClass.getMethod("getRandomizedMove", String.class, String.class);
            String result = (String)method.invoke(null, pokemonUUID, originalMoveName);
            return result != null ? result : originalMoveName;
        }
        catch (Exception e) {
            return originalMoveName;
        }
    }

    public static MoveTemplate getRandomizedMoveTemplate(Pokemon pokemon, MoveTemplate originalTemplate) {
        if (!RandomizerCompat.isRandomizerPresent() || pokemon == null || originalTemplate == null) {
            return originalTemplate;
        }
        try {
            String randomizedName = RandomizerCompat.getRandomizedMoveName(pokemon, originalTemplate.getName());
            if (randomizedName.equalsIgnoreCase(originalTemplate.getName())) {
                return originalTemplate;
            }
            MoveTemplate randomizedTemplate = RandomizerCompat.getByNameReflection(randomizedName);
            return randomizedTemplate != null ? randomizedTemplate : originalTemplate;
        }
        catch (Exception e) {
            return originalTemplate;
        }
    }

    private static MoveTemplate getByNameReflection(String moveName) {
        try {
            Class<?> movesClass = Class.forName("com.cobblemon.mod.common.api.moves.Moves");
            Field instanceField = movesClass.getDeclaredField("INSTANCE");
            Object instance = instanceField.get(null);
            Method getByNameMethod = instance.getClass().getMethod("getByName", String.class);
            return (MoveTemplate)getByNameMethod.invoke(instance, moveName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isRandomMovesEnabled() {
        if (!RandomizerCompat.isRandomizerPresent()) {
            return false;
        }
        try {
            Class<?> clientClass = Class.forName("cobblemon.randomizer.client.RandomizerClient");
            Method runActiveMethod = clientClass.getMethod("isRunActive", new Class[0]);
            Method randomMovesMethod = clientClass.getMethod("isRandomMoves", new Class[0]);
            boolean runActive = (Boolean)runActiveMethod.invoke(null, new Object[0]);
            boolean randomMoves = (Boolean)randomMovesMethod.invoke(null, new Object[0]);
            return runActive && randomMoves;
        }
        catch (Exception e) {
            return false;
        }
    }
}

