/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class TooltipRenderer {
    private static final int DEFAULT_BACKGROUND = -535816152;
    private static final int CORNER_RADIUS = 3;

    public static void renderStyledTooltip(class_332 graphics, class_327 font, List<class_2561> lines, int x, int y, int borderColor) {
        if (lines.isEmpty()) {
            return;
        }
        int maxWidth = 0;
        int separatorCount = 0;
        for (class_2561 line : lines) {
            int lineWidth = font.method_27525((class_5348)line);
            if (lineWidth > maxWidth) {
                maxWidth = lineWidth;
            }
            if (!line.getString().isEmpty()) continue;
            ++separatorCount;
        }
        int tooltipWidth = maxWidth + 12;
        int tooltipHeight = lines.size() * 9 + 10;
        if (lines.size() > 1) {
            ++tooltipHeight;
        }
        tooltipHeight += separatorCount * 2;
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        if (x + tooltipWidth > screenWidth - 4) {
            x = screenWidth - tooltipWidth - 4;
        }
        if (y + tooltipHeight > screenHeight - 4) {
            y = screenHeight - tooltipHeight - 4;
        }
        if (x < 4) {
            x = 4;
        }
        if (y < 4) {
            y = 4;
        }
        int borderStart = borderColor;
        int borderEnd = TooltipRenderer.darkenColor(borderColor, 0.6f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        TooltipRenderer.drawRoundedTooltipBox(graphics, x, y, tooltipWidth, tooltipHeight, -535816152, borderStart, borderEnd);
        class_4587 pose = graphics.method_51448();
        pose.method_22903();
        pose.method_46416(0.0f, 0.0f, 100.0f);
        int textY = y + 6;
        int textX = x + 5;
        int contentWidth = tooltipWidth - 10;
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            String lineStr = line.getString();
            if (lineStr.isEmpty()) {
                TooltipRenderer.drawFancySeparator(graphics, textX, textY + 2, contentWidth, borderStart);
                textY += 10;
                continue;
            }
            graphics.method_51439(font, line, textX, textY, -1, true);
            textY += 9;
            if (i != 0 || lines.size() <= 1) continue;
            TooltipRenderer.drawSubtleSeparator(graphics, textX, textY, contentWidth, borderStart);
            textY += 3;
        }
        pose.method_22909();
        RenderSystem.disableBlend();
    }

    private static void drawFancySeparator(class_332 graphics, int x, int y, int width, int accentColor) {
        int rightLineStart;
        int rightLineLen;
        int centerX = x + width / 2;
        int diamondSize = 2;
        int lineColor = TooltipRenderer.mixColors(accentColor, -1, 0.4f);
        int leftLineEnd = centerX - 5;
        int leftLineLen = leftLineEnd - x - 4;
        if (leftLineLen > 0) {
            for (int i = 0; i < leftLineLen; ++i) {
                float progress = (float)i / (float)leftLineLen;
                int alpha = (int)(progress * (float)(lineColor >> 24 & 0xFF));
                int fadedColor = alpha << 24 | lineColor & 0xFFFFFF;
                graphics.method_25294(x + 4 + i, y + 1, x + 4 + i + 1, y + 2, fadedColor);
            }
        }
        if ((rightLineLen = x + width - 4 - (rightLineStart = centerX + 5)) > 0) {
            for (int i = 0; i < rightLineLen; ++i) {
                float progress = 1.0f - (float)i / (float)rightLineLen;
                int alpha = (int)(progress * (float)(lineColor >> 24 & 0xFF));
                int fadedColor = alpha << 24 | lineColor & 0xFFFFFF;
                graphics.method_25294(rightLineStart + i, y + 1, rightLineStart + i + 1, y + 2, fadedColor);
            }
        }
        int dotColor = TooltipRenderer.mixColors(accentColor, -1, 0.5f);
        graphics.method_25294(centerX - diamondSize, y, centerX + diamondSize, y + 4, dotColor);
    }

    private static void drawSubtleSeparator(class_332 graphics, int x, int y, int width, int accentColor) {
        int lineColor = TooltipRenderer.mixColors(accentColor, -1, 0.3f);
        int lineLen = width;
        for (int i = 0; i < lineLen; ++i) {
            float fadeIn = Math.min(1.0f, (float)i / 10.0f);
            float fadeOut = Math.min(1.0f, (float)(lineLen - i) / 10.0f);
            float fade = Math.min(fadeIn, fadeOut);
            int alpha = (int)(fade * (float)(lineColor >> 24 & 0xFF));
            int fadedColor = alpha << 24 | lineColor & 0xFFFFFF;
            graphics.method_25294(x + i, y, x + i + 1, y + 1, fadedColor);
        }
    }

    private static void drawRoundedTooltipBox(class_332 graphics, int x, int y, int width, int height, int backgroundColor, int borderStart, int borderEnd) {
        int fadedColor;
        int alpha;
        int color;
        float fadeOut;
        float fadeIn;
        float progress;
        int i;
        int fadedColor2;
        int alpha2;
        int color2;
        float fade;
        float fadeOut2;
        float fadeIn2;
        float progress2;
        int i2;
        int r = 3;
        graphics.method_25294(x + r, y + r, x + width - r, y + height - r, backgroundColor);
        graphics.method_25294(x + r, y + 1, x + width - r, y + r, backgroundColor);
        graphics.method_25294(x + r, y + height - r, x + width - r, y + height - 1, backgroundColor);
        graphics.method_25294(x + 1, y + r, x + r, y + height - r, backgroundColor);
        graphics.method_25294(x + width - r, y + r, x + width - 1, y + height - r, backgroundColor);
        graphics.method_25294(x + 2, y + 2, x + r, y + r, backgroundColor);
        graphics.method_25294(x + width - r, y + 2, x + width - 2, y + r, backgroundColor);
        graphics.method_25294(x + 2, y + height - r, x + r, y + height - 2, backgroundColor);
        graphics.method_25294(x + width - r, y + height - r, x + width - 2, y + height - 2, backgroundColor);
        int topBorderLen = width - 2 * r;
        for (i2 = 0; i2 < topBorderLen; ++i2) {
            progress2 = (float)i2 / (float)topBorderLen;
            fadeIn2 = Math.min(1.0f, (float)i2 / 8.0f);
            fadeOut2 = Math.min(1.0f, (float)(topBorderLen - i2) / 8.0f);
            fade = Math.min(fadeIn2, fadeOut2);
            color2 = TooltipRenderer.mixColors(borderStart, borderEnd, progress2);
            alpha2 = (int)(fade * (float)(color2 >> 24 & 0xFF));
            fadedColor2 = alpha2 << 24 | color2 & 0xFFFFFF;
            graphics.method_25294(x + r + i2, y, x + r + i2 + 1, y + 1, fadedColor2);
        }
        for (i2 = 0; i2 < topBorderLen; ++i2) {
            progress2 = (float)i2 / (float)topBorderLen;
            fadeIn2 = Math.min(1.0f, (float)i2 / 8.0f);
            fadeOut2 = Math.min(1.0f, (float)(topBorderLen - i2) / 8.0f);
            fade = Math.min(fadeIn2, fadeOut2);
            color2 = TooltipRenderer.mixColors(borderEnd, borderStart, progress2);
            alpha2 = (int)(fade * (float)(color2 >> 24 & 0xFF));
            fadedColor2 = alpha2 << 24 | color2 & 0xFFFFFF;
            graphics.method_25294(x + r + i2, y + height - 1, x + r + i2 + 1, y + height, fadedColor2);
        }
        int sideBorderLen = height - 2 * r;
        for (i = 0; i < sideBorderLen; ++i) {
            progress = (float)i / (float)sideBorderLen;
            fadeIn = Math.min(1.0f, (float)i / 8.0f);
            fadeOut = Math.min(1.0f, (float)(sideBorderLen - i) / 8.0f);
            float fade2 = Math.min(fadeIn, fadeOut);
            color = TooltipRenderer.mixColors(borderStart, borderEnd, progress);
            alpha = (int)(fade2 * (float)(color >> 24 & 0xFF));
            fadedColor = alpha << 24 | color & 0xFFFFFF;
            graphics.method_25294(x, y + r + i, x + 1, y + r + i + 1, fadedColor);
        }
        for (i = 0; i < sideBorderLen; ++i) {
            progress = (float)i / (float)sideBorderLen;
            fadeIn = Math.min(1.0f, (float)i / 8.0f);
            fadeOut = Math.min(1.0f, (float)(sideBorderLen - i) / 8.0f);
            float fade3 = Math.min(fadeIn, fadeOut);
            color = TooltipRenderer.mixColors(borderEnd, borderStart, progress);
            alpha = (int)(fade3 * (float)(color >> 24 & 0xFF));
            fadedColor = alpha << 24 | color & 0xFFFFFF;
            graphics.method_25294(x + width - 1, y + r + i, x + width, y + r + i + 1, fadedColor);
        }
    }

    public static void renderTooltip(class_332 graphics, class_327 font, List<class_2561> lines, int x, int y, int maxWidth) {
        if (lines.isEmpty()) {
            return;
        }
        graphics.method_51437(font, lines, Optional.empty(), x, y);
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private static int darkenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * (1.0f - ratio) + (float)a2 * ratio);
        int r = (int)((float)r1 * (1.0f - ratio) + (float)r2 * ratio);
        int g = (int)((float)g1 * (1.0f - ratio) + (float)g2 * ratio);
        int b = (int)((float)b1 * (1.0f - ratio) + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

