/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.tooltip;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class NatureTooltipBuilder {
    public static List<class_2561> buildNatureTooltip(Pokemon pokemon) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        Nature nature = NatureTooltipBuilder.getEffectiveNature(pokemon);
        if (nature == null) {
            return lines;
        }
        class_5250 natureName = class_2561.method_43471((String)nature.getDisplayName());
        lines.add((class_2561)class_2561.method_43470((String)"\u2726 ").method_27692(class_124.field_1054).method_10852((class_2561)natureName.method_27661().method_27695(new class_124[]{class_124.field_1067, class_124.field_1068})).method_10852((class_2561)class_2561.method_43470((String)" Nature").method_27692(class_124.field_1080)));
        Stat increasedStat = nature.getIncreasedStat();
        Stat decreasedStat = nature.getDecreasedStat();
        if (increasedStat == null || decreasedStat == null || increasedStat.equals((Object)decreasedStat)) {
            lines.add((class_2561)class_2561.method_43470((String)"  \u2550 ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)"Neutral (No stat changes)").method_27692(class_124.field_1080)));
            return lines;
        }
        lines.add((class_2561)class_2561.method_43470((String)"  \u25b2 ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)NatureTooltipBuilder.getStatDisplayName(increasedStat)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" +10%").method_27692(class_124.field_1077)));
        lines.add((class_2561)class_2561.method_43470((String)"  \u25bc ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)NatureTooltipBuilder.getStatDisplayName(decreasedStat)).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" -10%").method_27692(class_124.field_1079)));
        return lines;
    }

    private static Nature getEffectiveNature(Pokemon pokemon) {
        if (pokemon == null) {
            return null;
        }
        try {
            Nature minted = NatureTooltipBuilder.invokeNatureMethod(pokemon, "getMintedNature");
            if (minted != null) {
                return minted;
            }
            minted = NatureTooltipBuilder.invokeNatureMethod(pokemon, "getMintNature");
            if (minted != null) {
                return minted;
            }
            minted = NatureTooltipBuilder.invokeNatureMethod(pokemon, "getEffectiveNature");
            if (minted != null) {
                return minted;
            }
            minted = NatureTooltipBuilder.invokeNatureMethod(pokemon, "getAppliedNature");
            if (minted != null) {
                return minted;
            }
            minted = NatureTooltipBuilder.invokeNatureMethod(pokemon, "getCurrentNature");
            if (minted != null) {
                return minted;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pokemon.getNature();
    }

    private static Nature invokeNatureMethod(Pokemon pokemon, String methodName) {
        try {
            Object result = pokemon.getClass().getMethod(methodName, new Class[0]).invoke((Object)pokemon, new Object[0]);
            if (result instanceof Nature) {
                Nature nature = (Nature)result;
                return nature;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getStatDisplayName(Stat stat) {
        if (stat == null) {
            return "Unknown";
        }
        String displayName = stat.getDisplayName().getString();
        if (displayName == null || displayName.isEmpty()) {
            if (stat == Stats.ATTACK) {
                return "Attack";
            }
            if (stat == Stats.DEFENCE) {
                return "Defense";
            }
            if (stat == Stats.SPECIAL_ATTACK) {
                return "Sp. Attack";
            }
            if (stat == Stats.SPECIAL_DEFENCE) {
                return "Sp. Defense";
            }
            if (stat == Stats.SPEED) {
                return "Speed";
            }
            if (stat == Stats.HP) {
                return "HP";
            }
        }
        return displayName != null ? displayName : "Unknown";
    }
}

