/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.tooltip;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class MoveTooltipBuilder {
    public static List<class_2561> buildTooltip(MoveTemplate moveTemplate, int currentPP, int maxPP, Pokemon pokemon) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (moveTemplate == null) {
            return tooltip;
        }
        try {
            String effectDesc;
            int typeColor = moveTemplate.getElementalType().getHue();
            String moveName = MoveTooltipBuilder.getLocalizedMoveName(moveTemplate);
            tooltip.add((class_2561)class_2561.method_43470((String)moveName).method_27694(style -> style.method_36139(typeColor).method_10982(Boolean.valueOf(true))));
            String typeName = MoveTooltipBuilder.getLocalizedTypeName(moveTemplate);
            String category = MoveTooltipBuilder.getLocalizedCategoryName(moveTemplate);
            tooltip.add((class_2561)class_2561.method_43470((String)(typeName + " | " + category)).method_27692(class_124.field_1080));
            String description = MoveTooltipBuilder.getLocalizedDescription(moveTemplate);
            if (description != null && !description.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43473());
                for (String line : MoveTooltipBuilder.wrapText(description, 26)) {
                    tooltip.add((class_2561)class_2561.method_43470((String)line).method_27695(new class_124[]{class_124.field_1068, class_124.field_1056}));
                }
            }
            boolean isStatus = moveTemplate.getDamageCategory() == DamageCategories.INSTANCE.getSTATUS();
            double power = moveTemplate.getPower();
            double accuracy = moveTemplate.getAccuracy();
            tooltip.add((class_2561)class_2561.method_43473());
            if (power > 0.0) {
                int basePower = (int)power;
                String powerLabel = class_2561.method_43471((String)"tooltip.cobblemon_party_extras.move.power").getString();
                tooltip.add((class_2561)class_2561.method_43470((String)(powerLabel + " " + basePower)).method_27692(class_124.field_1061));
            } else if (!isStatus) {
                String powerLabel = class_2561.method_43471((String)"tooltip.cobblemon_party_extras.move.power").getString();
                tooltip.add((class_2561)class_2561.method_43470((String)(powerLabel + " \u2014")).method_27692(class_124.field_1063));
            }
            if (accuracy > 0.0) {
                int baseAccuracy = (int)accuracy;
                String accuracyLabel = class_2561.method_43471((String)"tooltip.cobblemon_party_extras.move.accuracy").getString();
                tooltip.add((class_2561)class_2561.method_43470((String)(accuracyLabel + " " + baseAccuracy + "%")).method_27692(class_124.field_1078));
            } else {
                String accuracyLabel = class_2561.method_43471((String)"tooltip.cobblemon_party_extras.move.accuracy").getString();
                tooltip.add((class_2561)class_2561.method_43470((String)(accuracyLabel + " \u2014")).method_27692(class_124.field_1063));
            }
            double[] effectChances = MoveTooltipBuilder.getEffectChances(moveTemplate);
            if (effectChances != null && effectChances.length > 0 && effectChances[0] > 0.0 && effectChances[0] < 100.0 && (effectDesc = MoveTooltipBuilder.getSecondaryEffectDescription(moveTemplate)) != null && !effectDesc.isEmpty()) {
                String effectLabel = class_2561.method_43471((String)"tooltip.cobblemon_party_extras.move.effect").getString();
                tooltip.add((class_2561)class_2561.method_43470((String)(effectLabel + " " + (int)effectChances[0] + "% " + effectDesc)).method_27692(class_124.field_1076));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tooltip;
    }

    private static String getLocalizedMoveName(MoveTemplate moveTemplate) {
        try {
            Object displayNameComponent = moveTemplate.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)moveTemplate, new Object[0]);
            if (displayNameComponent != null) {
                return displayNameComponent.getClass().getMethod("getString", new Class[0]).invoke(displayNameComponent, new Object[0]).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MoveTooltipBuilder.formatMoveName(moveTemplate.getName());
    }

    private static String getLocalizedTypeName(MoveTemplate moveTemplate) {
        try {
            Object typeDisplayName = moveTemplate.getElementalType().getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)moveTemplate.getElementalType(), new Object[0]);
            return typeDisplayName.getClass().getMethod("getString", new Class[0]).invoke(typeDisplayName, new Object[0]).toString();
        }
        catch (Exception exception) {
            return MoveTooltipBuilder.capitalize(moveTemplate.getElementalType().getName());
        }
    }

    private static String getLocalizedCategoryName(MoveTemplate moveTemplate) {
        try {
            Object categoryDisplayName = moveTemplate.getDamageCategory().getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)moveTemplate.getDamageCategory(), new Object[0]);
            return categoryDisplayName.getClass().getMethod("getString", new Class[0]).invoke(categoryDisplayName, new Object[0]).toString();
        }
        catch (Exception exception) {
            return MoveTooltipBuilder.capitalize(moveTemplate.getDamageCategory().getName());
        }
    }

    private static String getLocalizedDescription(MoveTemplate moveTemplate) {
        try {
            String moveId = moveTemplate.getName().toLowerCase();
            String translationKey = "cobblemon.move." + moveId + ".desc";
            class_5250 descComponent = class_2561.method_43471((String)translationKey);
            String description = descComponent.getString();
            if (description != null && !description.isEmpty() && !description.equals(translationKey)) {
                return description;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static float calculateStabMultiplier(MoveTemplate moveTemplate, Pokemon pokemon) {
        if (pokemon == null) {
            return 1.0f;
        }
        try {
            String secondaryType;
            String moveType = moveTemplate.getElementalType().getName().toLowerCase();
            String primaryType = pokemon.getPrimaryType().getName().toLowerCase();
            String string = secondaryType = pokemon.getSecondaryType() != null ? pokemon.getSecondaryType().getName().toLowerCase() : null;
            if (moveType.equals(primaryType) || secondaryType != null && moveType.equals(secondaryType)) {
                return 1.5f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1.0f;
    }

    private static String formatMoveName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        String[] words = name.toLowerCase().replace("_", " ").replace("-", " ").split(" ");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(MoveTooltipBuilder.capitalize(words[i]));
        }
        return result.toString();
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    private static List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private static double[] getEffectChances(MoveTemplate moveTemplate) {
        try {
            Object result;
            try {
                Method method = moveTemplate.getClass().getMethod("getEffectChances", new Class[0]);
                result = method.invoke((Object)moveTemplate, new Object[0]);
                if (result instanceof Double[]) {
                    Double[] boxed = (Double[])result;
                    double[] unboxed = new double[boxed.length];
                    for (int i = 0; i < boxed.length; ++i) {
                        unboxed[i] = boxed[i];
                    }
                    return unboxed;
                }
                if (result instanceof double[]) {
                    return (double[])result;
                }
            }
            catch (NoSuchMethodException method) {
                // empty catch block
            }
            try {
                Field field = moveTemplate.getClass().getDeclaredField("effectChances");
                field.setAccessible(true);
                result = field.get(moveTemplate);
                if (result instanceof Double[]) {
                    Double[] boxed = (Double[])result;
                    double[] unboxed = new double[boxed.length];
                    for (int i = 0; i < boxed.length; ++i) {
                        unboxed[i] = boxed[i];
                    }
                    return unboxed;
                }
                if (result instanceof double[]) {
                    return (double[])result;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getSecondaryEffectDescription(MoveTemplate moveTemplate) {
        try {
            String moveName;
            String description = MoveTooltipBuilder.getLocalizedDescription(moveTemplate);
            if (description != null && !description.isEmpty()) {
                String descLower = description.toLowerCase();
                if (descLower.contains("burn")) {
                    return "Burn";
                }
                if (descLower.contains("paralyz")) {
                    return "Paralyze";
                }
                if (descLower.contains("poison")) {
                    return "Poison";
                }
                if (descLower.contains("freeze") || descLower.contains("frozen")) {
                    return "Freeze";
                }
                if (descLower.contains("sleep") || descLower.contains("asleep")) {
                    return "Sleep";
                }
                if (descLower.contains("confus")) {
                    return "Confuse";
                }
                if (descLower.contains("flinch")) {
                    return "Flinch";
                }
                if (descLower.contains("lower") || descLower.contains("reduce") || descLower.contains("drop")) {
                    if (descLower.contains("defense") || descLower.contains("defence")) {
                        return "Lower Def";
                    }
                    if (descLower.contains("attack")) {
                        return "Lower Atk";
                    }
                    if (descLower.contains("speed")) {
                        return "Lower Spe";
                    }
                    if (descLower.contains("special attack") || descLower.contains("sp. atk")) {
                        return "Lower SpA";
                    }
                    if (descLower.contains("special defense") || descLower.contains("sp. def")) {
                        return "Lower SpD";
                    }
                    if (descLower.contains("accuracy")) {
                        return "Lower Acc";
                    }
                    if (descLower.contains("evasion") || descLower.contains("evasive")) {
                        return "Lower Eva";
                    }
                    return "Lower Stat";
                }
                if (descLower.contains("raise") || descLower.contains("boost") || descLower.contains("increase")) {
                    if (descLower.contains("defense") || descLower.contains("defence")) {
                        return "Raise Def";
                    }
                    if (descLower.contains("attack")) {
                        return "Raise Atk";
                    }
                    if (descLower.contains("speed")) {
                        return "Raise Spe";
                    }
                    if (descLower.contains("special attack") || descLower.contains("sp. atk")) {
                        return "Raise SpA";
                    }
                    if (descLower.contains("special defense") || descLower.contains("sp. def")) {
                        return "Raise SpD";
                    }
                    return "Raise Stat";
                }
                if (descLower.contains("recoil")) {
                    return "Recoil";
                }
                if (descLower.contains("drain") || descLower.contains("absorb")) {
                    return "Drain HP";
                }
                if (descLower.contains("critical")) {
                    return "High Crit";
                }
                if (descLower.contains("trap") || descLower.contains("bind")) {
                    return "Trap";
                }
            }
            if ((moveName = moveTemplate.getName().toLowerCase()).contains("thunder") || moveName.contains("spark") || moveName.contains("discharge") || moveName.contains("nuzzle") || moveName.contains("zap") || moveName.contains("bolt")) {
                return "Paralyze";
            }
            if (moveName.contains("fire") || moveName.contains("flame") || moveName.contains("burn") || moveName.contains("blaze") || moveName.contains("heat") || moveName.contains("scald") || moveName.contains("lava") || moveName.contains("inferno") || moveName.contains("ember")) {
                return "Burn";
            }
            if (moveName.contains("ice") || moveName.contains("freeze") || moveName.contains("blizzard") || moveName.contains("frost") || moveName.contains("cold")) {
                return "Freeze";
            }
            if (moveName.contains("poison") || moveName.contains("toxic") || moveName.contains("sludge") || moveName.contains("venom") || moveName.contains("gunk")) {
                return "Poison";
            }
            if (moveName.contains("confus") || moveName.contains("dizzy") || moveName.contains("teeter")) {
                return "Confuse";
            }
            if (moveName.contains("headbutt") || moveName.contains("bite") || moveName.contains("fang") || moveName.contains("stomp") || moveName.contains("iron head") || moveName.contains("rock slide") || moveName.contains("air slash") || moveName.contains("zen headbutt") || moveName.contains("waterfall") || moveName.contains("dark pulse") || moveName.contains("twister") || moveName.contains("astonish") || moveName.contains("extrasensory") || moveName.contains("icicle crash") || moveName.contains("sky attack")) {
                return "Flinch";
            }
            return "Effect";
        }
        catch (Exception e) {
            return "Effect";
        }
    }
}

