/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.tooltip;

import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class DexTooltipBuilder {
    public static List<class_2561> buildDexTooltip(Pokemon pokemon) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        try {
            class_2561 generation;
            List<class_2561> classificationComponents;
            List<String> allForms;
            int dexNumber = pokemon.getSpecies().getNationalPokedexNumber();
            String dexStr = String.format("#%04d", dexNumber);
            String speciesName = pokemon.getSpecies().getTranslatedName().getString();
            String formName = DexTooltipBuilder.getFormDisplayName(pokemon);
            class_5250 header = class_2561.method_43470((String)"\u2605 ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)dexStr).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)speciesName).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}));
            tooltip.add((class_2561)header);
            if (formName != null && !formName.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43470((String)"  \u25c7 ").method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)formName).method_27692(class_124.field_1075)));
            }
            if ((allForms = DexTooltipBuilder.getAllForms(pokemon)).size() > 1) {
                List<class_2561> formLines = DexTooltipBuilder.buildWrappedFormLines(allForms, 35);
                for (class_2561 line : formLines) {
                    tooltip.add(line);
                }
            }
            if (!(classificationComponents = DexTooltipBuilder.getClassification(pokemon)).isEmpty()) {
                for (class_2561 comp : classificationComponents) {
                    tooltip.add(comp);
                }
            }
            if ((generation = DexTooltipBuilder.getGeneration(pokemon)) != null) {
                tooltip.add(generation);
            }
        }
        catch (Exception e) {
            tooltip.add((class_2561)class_2561.method_43470((String)"Pokemon Info").method_27692(class_124.field_1068));
        }
        return tooltip;
    }

    private static String getFormDisplayName(Pokemon pokemon) {
        try {
            String formName = pokemon.getForm().getName();
            if (formName == null || formName.isEmpty()) {
                return null;
            }
            String lowerForm = formName.toLowerCase();
            if (lowerForm.equals("normal") || lowerForm.equals("standard") || lowerForm.equals("default") || lowerForm.equals("base")) {
                return null;
            }
            return DexTooltipBuilder.formatFormName(formName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<String> getAllForms(Pokemon pokemon) {
        ArrayList<String> forms = new ArrayList<String>();
        try {
            List allForms = pokemon.getSpecies().getForms();
            for (FormData form : allForms) {
                String lowerName;
                String name = form.getName();
                if (name == null || name.isEmpty() || (lowerName = name.toLowerCase()).equals("normal") || lowerName.equals("standard") || lowerName.equals("default") || lowerName.equals("base")) continue;
                forms.add(DexTooltipBuilder.formatFormName(name));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return forms;
    }

    private static String formatFormName(String formName) {
        if (formName == null) {
            return null;
        }
        String formatted = formName.replace("_", " ").replace("-", " ");
        String[] words = formatted.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(DexTooltipBuilder.capitalize(word));
        }
        String lower = formName.toLowerCase();
        if (lower.contains("strike")) {
            return String.valueOf(result) + " Style";
        }
        return result.toString();
    }

    private static List<class_2561> getClassification(Pokemon pokemon) {
        ArrayList<class_2561> classifications = new ArrayList<class_2561>();
        try {
            Set labels = pokemon.getForm().getLabels();
            if (labels.contains("legendary")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u2727 ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.legendary").method_27692(class_124.field_1076)));
            }
            if (labels.contains("mythical")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u2727 ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.mythical").method_27692(class_124.field_1076)));
            }
            if (labels.contains("ultra_beast")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u2b21 ").method_27692(class_124.field_1064).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.ultra_beast").method_27692(class_124.field_1076)));
            }
            if (labels.contains("paradox")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u27f3 ").method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.paradox").method_27692(class_124.field_1076)));
            }
            if (labels.contains("powerhouse")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u25c8 ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.pseudo_legendary").method_27692(class_124.field_1076)));
            }
            if (labels.contains("fossil")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u2692 ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.fossil").method_27692(class_124.field_1076)));
            }
            if (labels.contains("baby")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u2661 ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.baby").method_27692(class_124.field_1076)));
            }
            if (labels.contains("alolan_form")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u2600 ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.alolan_form").method_27692(class_124.field_1075)));
            } else if (labels.contains("galarian_form")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u2694 ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.galarian_form").method_27692(class_124.field_1075)));
            } else if (labels.contains("hisuian_form")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u274b ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.hisuian_form").method_27692(class_124.field_1075)));
            } else if (labels.contains("paldean_form")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u273f ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.paldean_form").method_27692(class_124.field_1075)));
            }
            if (labels.contains("mega")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u03a9 ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.mega").method_27692(class_124.field_1076)));
            }
            if (labels.contains("primal")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u03b1 ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.primal").method_27692(class_124.field_1076)));
            }
            if (labels.contains("gmax")) {
                classifications.add((class_2561)class_2561.method_43470((String)"  \u2b22 ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.species.gmax").method_27692(class_124.field_1076)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classifications;
    }

    private static class_2561 getGeneration(Pokemon pokemon) {
        try {
            Set labels = pokemon.getForm().getLabels();
            for (String label : labels) {
                if (!label.startsWith("gen")) continue;
                String genNum = label.substring(3);
                if (genNum.endsWith("b") || genNum.endsWith("a")) {
                    String num = genNum.substring(0, genNum.length() - 1);
                    String romanNum = DexTooltipBuilder.toRoman(Integer.parseInt(num));
                    if (genNum.endsWith("a")) {
                        return class_2561.method_43470((String)"  \u2318 ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43469((String)"tooltip.cobblemon_party_extras.species.generation_legends", (Object[])new Object[]{romanNum}).method_27692(class_124.field_1080));
                    }
                    return class_2561.method_43470((String)"  \u2318 ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43469((String)"tooltip.cobblemon_party_extras.species.generation_lets_go", (Object[])new Object[]{romanNum}).method_27692(class_124.field_1080));
                }
                try {
                    int gen = Integer.parseInt(genNum);
                    return class_2561.method_43470((String)"  \u2318 ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43469((String)"tooltip.cobblemon_party_extras.species.generation", (Object[])new Object[]{DexTooltipBuilder.toRoman(gen)}).method_27692(class_124.field_1080));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String toRoman(int num) {
        String[] romans = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        if (num >= 1 && num <= 9) {
            return romans[num];
        }
        return String.valueOf(num);
    }

    private static List<class_2561> buildWrappedFormLines(List<String> forms, int maxCharsPerLine) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        StringBuilder currentLine = new StringBuilder();
        boolean isFirstLine = true;
        for (int i = 0; i < forms.size(); ++i) {
            String form = forms.get(i);
            String separator = i > 0 ? ", " : "";
            String toAdd = separator + form;
            if (currentLine.length() + toAdd.length() > maxCharsPerLine && currentLine.length() > 0) {
                if (isFirstLine) {
                    lines.add((class_2561)class_2561.method_43470((String)"  Forms: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)currentLine.toString()).method_27692(class_124.field_1062)));
                    isFirstLine = false;
                } else {
                    lines.add((class_2561)class_2561.method_43470((String)"    ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)currentLine.toString()).method_27692(class_124.field_1062)));
                }
                currentLine = new StringBuilder(form);
                continue;
            }
            currentLine.append(toAdd);
        }
        if (currentLine.length() > 0) {
            if (isFirstLine) {
                lines.add((class_2561)class_2561.method_43470((String)"  Forms: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)currentLine.toString()).method_27692(class_124.field_1062)));
            } else {
                lines.add((class_2561)class_2561.method_43470((String)"    ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)currentLine.toString()).method_27692(class_124.field_1062)));
            }
        }
        return lines;
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }
}

