/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.tooltip;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.types.ElementalType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CondensedMoveTooltipBuilder {
    public static List<class_2561> buildTooltip(MoveTemplate moveTemplate) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (moveTemplate == null) {
            return tooltip;
        }
        try {
            int typeColor = moveTemplate.getElementalType().getHue();
            String moveName = CondensedMoveTooltipBuilder.getLocalizedMoveName(moveTemplate);
            tooltip.add((class_2561)class_2561.method_43470((String)moveName).method_27694(style -> style.method_36139(typeColor).method_10982(Boolean.valueOf(true))));
            String typeName = CondensedMoveTooltipBuilder.getLocalizedTypeName(moveTemplate.getElementalType());
            String categoryName = CondensedMoveTooltipBuilder.getLocalizedCategoryName(moveTemplate.getDamageCategory());
            tooltip.add((class_2561)class_2561.method_43470((String)(typeName + " | " + categoryName)).method_27692(class_124.field_1080));
            String description = CondensedMoveTooltipBuilder.getLocalizedDescription(moveTemplate);
            if (description != null && !description.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43473());
                for (String line : CondensedMoveTooltipBuilder.wrapText(description, 40)) {
                    tooltip.add((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1068));
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43473());
                tooltip.add((class_2561)class_2561.method_43470((String)"No description available.").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tooltip;
    }

    private static String getLocalizedMoveName(MoveTemplate moveTemplate) {
        try {
            Object displayNameComponent = moveTemplate.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)moveTemplate, new Object[0]);
            if (displayNameComponent != null) {
                return displayNameComponent.getClass().getMethod("getString", new Class[0]).invoke(displayNameComponent, new Object[0]).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CondensedMoveTooltipBuilder.formatMoveName(moveTemplate.getName());
    }

    private static String getLocalizedTypeName(ElementalType type) {
        try {
            Object displayName = type.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)type, new Object[0]);
            return displayName.getClass().getMethod("getString", new Class[0]).invoke(displayName, new Object[0]).toString();
        }
        catch (Exception e) {
            return CondensedMoveTooltipBuilder.capitalize(type.getName());
        }
    }

    private static String getLocalizedCategoryName(DamageCategory category) {
        try {
            Object displayName = category.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)category, new Object[0]);
            return displayName.getClass().getMethod("getString", new Class[0]).invoke(displayName, new Object[0]).toString();
        }
        catch (Exception e) {
            return CondensedMoveTooltipBuilder.capitalize(category.getName());
        }
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    private static String getLocalizedDescription(MoveTemplate moveTemplate) {
        try {
            String moveId = moveTemplate.getName().toLowerCase();
            String translationKey = "cobblemon.move." + moveId + ".desc";
            class_5250 descComponent = class_2561.method_43471((String)translationKey);
            String description = descComponent.getString();
            if (description != null && !description.isEmpty() && !description.equals(translationKey)) {
                return description;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String formatMoveName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        String[] words = name.toLowerCase().replace("_", " ").replace("-", " ").split(" ");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            if (words[i].isEmpty()) continue;
            result.append(words[i].substring(0, 1).toUpperCase()).append(words[i].substring(1));
        }
        return result.toString();
    }

    private static List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }
}

