/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.tooltip;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.abilities.AbilityPool;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class AbilityTooltipBuilder {
    public static List<class_2561> buildAbilityTooltip(Pokemon pokemon) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        try {
            Ability currentAbility = pokemon.getAbility();
            if (currentAbility == null) {
                return lines;
            }
            String currentAbilityKey = currentAbility.getDisplayName();
            class_5250 currentAbilityName = class_2561.method_43471((String)currentAbilityKey);
            String currentAbilityString = currentAbilityName.getString();
            boolean isCurrentHidden = AbilityTooltipBuilder.isHiddenAbility(pokemon, currentAbility);
            if (isCurrentHidden) {
                lines.add((class_2561)class_2561.method_43470((String)"\u2b22 ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)currentAbilityString).method_27695(new class_124[]{class_124.field_1067, class_124.field_1068})).method_10852((class_2561)class_2561.method_43470((String)" (Hidden)").method_27692(class_124.field_1076)));
            } else {
                lines.add((class_2561)class_2561.method_43470((String)"\u2b22 ").method_27694(style -> style.method_36139(0x55AAFF)).method_10852((class_2561)class_2561.method_43470((String)currentAbilityString).method_27695(new class_124[]{class_124.field_1067, class_124.field_1068})));
            }
            lines.add((class_2561)class_2561.method_43473());
            ArrayList<String> regularAbilities = new ArrayList<String>();
            ArrayList<String> hiddenAbilities = new ArrayList<String>();
            try {
                AbilityPool abilityPool = pokemon.getForm().getAbilities();
                Method getMappingMethod = abilityPool.getClass().getMethod("getMapping", new Class[0]);
                Map mapping = (Map)getMappingMethod.invoke((Object)abilityPool, new Object[0]);
                for (Map.Entry entry : mapping.entrySet()) {
                    List abilities = (List)entry.getValue();
                    for (PotentialAbility potential : abilities) {
                        String abilityName = class_2561.method_43471((String)potential.getTemplate().getDisplayName()).getString();
                        if (potential instanceof HiddenAbility) {
                            if (hiddenAbilities.contains(abilityName)) continue;
                            hiddenAbilities.add(abilityName);
                            continue;
                        }
                        if (regularAbilities.contains(abilityName)) continue;
                        regularAbilities.add(abilityName);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!regularAbilities.isEmpty()) {
                lines.add((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.ability.regular").method_27694(style -> style.method_36139(0x55AAFF)));
                for (String ability : regularAbilities) {
                    boolean isCurrent = ability.equalsIgnoreCase(currentAbilityString);
                    if (isCurrent) {
                        lines.add((class_2561)class_2561.method_43470((String)"  \u25ba ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)ability).method_27692(class_124.field_1060)));
                        continue;
                    }
                    lines.add((class_2561)class_2561.method_43470((String)"  \u25cb ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)ability).method_27692(class_124.field_1080)));
                }
            }
            if (!hiddenAbilities.isEmpty()) {
                if (!regularAbilities.isEmpty()) {
                    lines.add((class_2561)class_2561.method_43473());
                }
                lines.add((class_2561)class_2561.method_43471((String)"tooltip.cobblemon_party_extras.ability.hidden").method_27692(class_124.field_1076));
                for (String ability : hiddenAbilities) {
                    boolean isCurrent = ability.equalsIgnoreCase(currentAbilityString);
                    if (isCurrent) {
                        lines.add((class_2561)class_2561.method_43470((String)"  \u25ba ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)ability).method_27692(class_124.field_1060)));
                        continue;
                    }
                    lines.add((class_2561)class_2561.method_43470((String)"  \u25cb ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)ability).method_27692(class_124.field_1080)));
                }
            }
        }
        catch (Exception e) {
            lines.clear();
        }
        return lines;
    }

    private static boolean isHiddenAbility(Pokemon pokemon, Ability currentAbility) {
        try {
            AbilityPool abilityPool = pokemon.getForm().getAbilities();
            Method getMappingMethod = abilityPool.getClass().getMethod("getMapping", new Class[0]);
            Map mapping = (Map)getMappingMethod.invoke((Object)abilityPool, new Object[0]);
            for (Map.Entry entry : mapping.entrySet()) {
                for (PotentialAbility potential : (List)entry.getValue()) {
                    if (!potential.getTemplate().getName().equals(currentAbility.getTemplate().getName())) continue;
                    return potential instanceof HiddenAbility;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

