/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.gui;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import party.extras.cobblemon.client.gui.TeamAnalysis;
import party.extras.cobblemon.client.gui.TeamAnalyzer;

public class TeamAnalyzerScreen
extends class_437 {
    private final class_437 parentScreen;
    private final List<Pokemon> party;
    private final TeamAnalysis analysis;
    private static final int PANEL_WIDTH = 300;
    private static final int PANEL_HEIGHT = 200;
    private static final int CORNER_RADIUS = 4;
    private static final int BACKGROUND_COLOR = -401598424;
    private static final int BORDER_START = -11171585;
    private static final int BORDER_END = -14531414;
    private static final int TITLE_COLOR = -11154177;
    private static final int OVERVIEW_COLOR = -8875;
    private static final int COVERAGE_COLOR = -11141291;
    private static final int WEAKNESS_COLOR = -43691;
    private static final int RESISTANCE_COLOR = -11141121;
    private static final int SUGGESTION_COLOR = -43521;
    private int panelX;
    private int panelY;
    private int scrollOffset = 0;
    private int maxScroll = 250;
    private List<WeaknessEntry> weaknessEntries = new ArrayList<WeaknessEntry>();

    public TeamAnalyzerScreen(class_437 parent, List<Pokemon> party) {
        super((class_2561)class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.title"));
        this.parentScreen = parent;
        this.party = party;
        this.analysis = TeamAnalyzer.analyze(party);
    }

    protected void method_25426() {
        super.method_25426();
        this.panelX = (this.field_22789 - 300) / 2;
        this.panelY = (this.field_22790 - 200) / 2;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.weaknessEntries.clear();
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -1610612736);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawRoundedPanel(graphics, this.panelX, this.panelY, 300, 200);
        RenderSystem.disableBlend();
        class_327 font = class_310.method_1551().field_1772;
        class_5250 titleComponent = class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.title");
        String title = "\u2605 " + titleComponent.getString();
        int titleWidth = font.method_1727(title);
        graphics.method_51433(font, title, this.panelX + (300 - titleWidth) / 2, this.panelY + 8, -11154177, true);
        this.drawFancySeparator(graphics, this.panelX + 10, this.panelY + 20, 280, -11171585);
        int contentY = this.panelY + 28 - this.scrollOffset;
        graphics.method_44379(this.panelX + 6, this.panelY + 24, this.panelX + 300 - 6, this.panelY + 200 - 18);
        contentY = this.renderTeamOverview(graphics, font, this.panelX + 12, contentY);
        contentY = this.renderSectionSeparator(graphics, this.panelX + 12, contentY + 6, 276, -8875);
        contentY = this.renderTypeCoverage(graphics, font, this.panelX + 12, contentY + 4);
        contentY = this.renderSectionSeparator(graphics, this.panelX + 12, contentY + 6, 276, -11141291);
        contentY = this.renderWeaknesses(graphics, font, this.panelX + 12, contentY + 4, mouseX, mouseY);
        contentY = this.renderSectionSeparator(graphics, this.panelX + 12, contentY + 6, 276, -43691);
        contentY = this.renderResistances(graphics, font, this.panelX + 12, contentY + 4);
        contentY = this.renderSectionSeparator(graphics, this.panelX + 12, contentY + 6, 276, -11141121);
        contentY = this.renderSuggestions(graphics, font, this.panelX + 12, contentY + 4);
        int contentHeight = contentY - (this.panelY + 28 - this.scrollOffset);
        int visibleHeight = 154;
        this.maxScroll = Math.max(0, contentHeight - visibleHeight + 20);
        graphics.method_44380();
        String closeHint = class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.close_hint").getString();
        graphics.method_51433(font, closeHint, this.panelX + (300 - font.method_1727(closeHint)) / 2, this.panelY + 200 - 12, 0x666666, false);
        this.renderWeaknessTooltip(graphics, font, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    private void drawRoundedPanel(class_332 graphics, int x, int y, int width, int height) {
        int r = 4;
        graphics.method_25294(x + r, y + r, x + width - r, y + height - r, -401598424);
        graphics.method_25294(x + r, y + 2, x + width - r, y + r, -401598424);
        graphics.method_25294(x + r, y + height - r, x + width - r, y + height - 2, -401598424);
        graphics.method_25294(x + 2, y + r, x + r, y + height - r, -401598424);
        graphics.method_25294(x + width - r, y + r, x + width - 2, y + height - r, -401598424);
        graphics.method_25294(x + 3, y + 3, x + r, y + r, -401598424);
        graphics.method_25294(x + width - r, y + 3, x + width - 3, y + r, -401598424);
        graphics.method_25294(x + 3, y + height - r, x + r, y + height - 3, -401598424);
        graphics.method_25294(x + width - r, y + height - r, x + width - 3, y + height - 3, -401598424);
        graphics.method_25296(x + r, y, x + width - r, y + 2, -11171585, -14531414);
        graphics.method_25296(x + r, y + height - 2, x + width - r, y + height, -14531414, -11171585);
        graphics.method_25296(x, y + r, x + 2, y + height - r, -11171585, -14531414);
        graphics.method_25296(x + width - 2, y + r, x + width, y + height - r, -14531414, -11171585);
        graphics.method_25294(x + 2, y + 3, x + 3, y + r, -11171585);
        graphics.method_25294(x + 3, y + 2, x + r, y + 3, -11171585);
        int topRightColor = TeamAnalyzerScreen.mixColors(-11171585, -14531414, 0.5f);
        graphics.method_25294(x + width - 3, y + 3, x + width - 2, y + r, topRightColor);
        graphics.method_25294(x + width - r, y + 2, x + width - 3, y + 3, topRightColor);
        int bottomLeftColor = TeamAnalyzerScreen.mixColors(-11171585, -14531414, 0.5f);
        graphics.method_25294(x + 2, y + height - r, x + 3, y + height - 3, bottomLeftColor);
        graphics.method_25294(x + 3, y + height - 3, x + r, y + height - 2, bottomLeftColor);
        graphics.method_25294(x + width - 3, y + height - r, x + width - 2, y + height - 3, -14531414);
        graphics.method_25294(x + width - r, y + height - 3, x + width - 3, y + height - 2, -14531414);
    }

    private void drawFancySeparator(class_332 graphics, int x, int y, int width, int accentColor) {
        int centerX = x + width / 2;
        int lineColor = TeamAnalyzerScreen.mixColors(accentColor, 0xFFFFFF, 0.4f);
        int fadeColor = TeamAnalyzerScreen.mixColors(accentColor, 0xFFFFFF, 0.15f);
        graphics.method_25296(x + 4, y, centerX - 6, y + 1, fadeColor, lineColor);
        graphics.method_25296(centerX + 6, y, x + width - 4, y + 1, lineColor, fadeColor);
        int dotColor = TeamAnalyzerScreen.mixColors(accentColor, -1, 0.6f);
        graphics.method_25294(centerX - 2, y - 1, centerX + 3, y + 2, dotColor);
    }

    private int renderSectionSeparator(class_332 graphics, int x, int y, int width, int accentColor) {
        int lineColor = TeamAnalyzerScreen.mixColors(accentColor, 0, 0.3f);
        int fadeColor = TeamAnalyzerScreen.mixColors(accentColor, 0, 0.1f);
        graphics.method_25296(x, y, x + width / 2, y + 1, fadeColor, lineColor);
        graphics.method_25296(x + width / 2, y, x + width, y + 1, lineColor, fadeColor);
        return y + 4;
    }

    private int getTypeColor(String type) {
        ElementalType elementalType = this.getElementalTypeFromName(type);
        if (elementalType != null) {
            return 0xFF000000 | elementalType.getHue();
        }
        return -5592406;
    }

    private int renderColoredTypeList(class_332 graphics, class_327 font, int x, int y, String prefix, Set<String> types, int maxWidth) {
        int currentX = x;
        int startX = x;
        int lineHeight = 10;
        graphics.method_51433(font, prefix, currentX, y, 0xAAAAAA, false);
        currentX += font.method_1727(prefix);
        int typeIndex = 0;
        for (String type : types) {
            int typeWidth;
            String typeName = this.formatTypeName(type);
            String separator = typeIndex > 0 ? ", " : "";
            int separatorWidth = font.method_1727(separator);
            if (currentX + separatorWidth + (typeWidth = font.method_1727(typeName)) > startX + maxWidth && typeIndex > 0) {
                y += lineHeight;
                currentX = startX + font.method_1727("    ");
                separator = "";
                separatorWidth = 0;
            }
            if (!separator.isEmpty()) {
                graphics.method_51433(font, separator, currentX, y, 0xAAAAAA, false);
                currentX += separatorWidth;
            }
            int typeColor = this.getTypeColor(type);
            graphics.method_51433(font, typeName, currentX, y, typeColor, false);
            currentX += typeWidth;
            ++typeIndex;
        }
        return y + lineHeight;
    }

    private int renderTeamOverview(class_332 graphics, class_327 font, int x, int y) {
        String title = "\u25c6 " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.overview.title").getString();
        graphics.method_51433(font, title, x, y, -8875, true);
        y += 12;
        String desc = class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.overview.description").getString();
        List<String> descLines = this.wrapText("  " + desc, 260, font);
        for (String line : descLines) {
            graphics.method_51433(font, line, x, y, 0x888888, false);
            y += 10;
        }
        String pokemonCountText = class_2561.method_43469((String)"screen.cobblemon_party_extras.team_analyzer.overview.pokemon_count", (Object[])new Object[]{this.analysis.pokemonCount}).getString();
        graphics.method_51433(font, "  " + pokemonCountText, x, y += 2, 0xCCCCCC, false);
        y += 10;
        String typesPrefix = "  " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.overview.types").getString() + " ";
        y = this.renderColoredTypeList(graphics, font, x, y, typesPrefix, this.analysis.teamTypes, 260);
        return y;
    }

    private int renderTypeCoverage(class_332 graphics, class_327 font, int x, int y) {
        String title = "\u25c6 " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.coverage.title").getString();
        graphics.method_51433(font, title, x, y, -11141291, true);
        y += 12;
        if (this.analysis.superEffectiveAgainst.isEmpty()) {
            graphics.method_51433(font, "  " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.coverage.none").getString(), x, y, 0x888888, false);
            y += 10;
        } else {
            String hitsPrefix = "  " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.coverage.hits_se").getString() + " ";
            y = this.renderColoredTypeList(graphics, font, x, y, hitsPrefix, this.analysis.superEffectiveAgainst, 260);
        }
        if (!this.analysis.missingCoverage.isEmpty()) {
            String missPrefix = "  " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.coverage.missing").getString() + " ";
            y = this.renderColoredTypeList(graphics, font, x, y, missPrefix, this.analysis.missingCoverage, 260);
        }
        return y;
    }

    private int renderWeaknesses(class_332 graphics, class_327 font, int x, int y, int mouseX, int mouseY) {
        String weaknessTitle = class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.weaknesses.title").getString();
        String hoverHint = class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.weaknesses.hover").getString();
        graphics.method_51433(font, "\u25c6 " + weaknessTitle, x, y, -43691, true);
        graphics.method_51433(font, " " + hoverHint, x + font.method_1727("\u25c6 " + weaknessTitle), y, 0x666666, false);
        y += 12;
        if (this.analysis.sharedWeaknesses.isEmpty()) {
            graphics.method_51433(font, "  " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.weaknesses.none").getString(), x, y, 0x888888, false);
            y += 10;
        } else {
            for (Map.Entry<String, Integer> entry : this.analysis.sharedWeaknesses.entrySet()) {
                String type = entry.getKey();
                int count = entry.getValue();
                int typeColor = this.getTypeColor(type);
                String formattedType = this.formatTypeName(type);
                String weakLabel = class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.weaknesses.weak_label").getString();
                String prefix = "  \u25b8 ";
                graphics.method_51433(font, prefix, x, y, 0xAAAAAA, false);
                int currentX = x + font.method_1727(prefix);
                graphics.method_51433(font, formattedType, currentX, y, typeColor, false);
                int severityColor = count >= 4 ? -48060 : (count >= 3 ? -30652 : -13244);
                String countText = " (" + count + " " + weakLabel + ")";
                graphics.method_51433(font, countText, currentX += font.method_1727(formattedType), y, severityColor, false);
                int textWidth = font.method_1727(prefix + formattedType + countText);
                List<String> pokemonNames = this.analysis.weaknessPokemonNames.get(type);
                if (pokemonNames != null) {
                    this.weaknessEntries.add(new WeaknessEntry(x, y, textWidth, 10, type, pokemonNames));
                }
                y += 10;
            }
        }
        return y;
    }

    private void renderWeaknessTooltip(class_332 graphics, class_327 font, int mouseX, int mouseY) {
        for (WeaknessEntry entry : this.weaknessEntries) {
            int n;
            if (mouseX < entry.x || mouseX > entry.x + entry.width || mouseY < entry.y || mouseY > entry.y + entry.height) continue;
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            String tooltipTitle = class_2561.method_43469((String)"screen.cobblemon_party_extras.team_analyzer.weaknesses.tooltip.title", (Object[])new Object[]{this.formatTypeName(entry.type)}).getString();
            tooltipLines.add(tooltipTitle);
            for (String string : entry.pokemonNames) {
                tooltipLines.add("  \u2022 " + string);
            }
            int tooltipWidth = 0;
            for (String string : tooltipLines) {
                int lineWidth = font.method_1727(string);
                if (lineWidth <= tooltipWidth) continue;
                tooltipWidth = lineWidth;
            }
            int n2 = tooltipLines.size() * 10 + 10;
            int n3 = mouseX + 12;
            int tooltipY = mouseY - 5;
            if (n3 + (tooltipWidth += 16) > this.field_22789) {
                n = mouseX - tooltipWidth - 5;
            }
            if (tooltipY + n2 > this.field_22790) {
                tooltipY = this.field_22790 - n2;
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
            this.drawRoundedTooltip(graphics, n, tooltipY, tooltipWidth, n2, -43691);
            int textY = tooltipY + 5;
            boolean first = true;
            for (String string : tooltipLines) {
                int color = first ? -43691 : 0xCCCCCC;
                graphics.method_51433(font, string, n + 6, textY, color, first);
                textY += 10;
                first = false;
            }
            graphics.method_51448().method_22909();
            break;
        }
    }

    private void drawRoundedTooltip(class_332 graphics, int x, int y, int width, int height, int borderColor) {
        int r = 3;
        int bgColor = -267380696;
        int borderEnd = TeamAnalyzerScreen.darkenColor(borderColor, 0.6f);
        graphics.method_25294(x + r, y + r, x + width - r, y + height - r, bgColor);
        graphics.method_25294(x + r, y + 1, x + width - r, y + r, bgColor);
        graphics.method_25294(x + r, y + height - r, x + width - r, y + height - 1, bgColor);
        graphics.method_25294(x + 1, y + r, x + r, y + height - r, bgColor);
        graphics.method_25294(x + width - r, y + r, x + width - 1, y + height - r, bgColor);
        graphics.method_25294(x + 2, y + 2, x + r, y + r, bgColor);
        graphics.method_25294(x + width - r, y + 2, x + width - 2, y + r, bgColor);
        graphics.method_25294(x + 2, y + height - r, x + r, y + height - 2, bgColor);
        graphics.method_25294(x + width - r, y + height - r, x + width - 2, y + height - 2, bgColor);
        graphics.method_25296(x + r, y, x + width - r, y + 1, borderColor, borderEnd);
        graphics.method_25296(x + r, y + height - 1, x + width - r, y + height, borderEnd, borderColor);
        graphics.method_25296(x, y + r, x + 1, y + height - r, borderColor, borderEnd);
        graphics.method_25296(x + width - 1, y + r, x + width, y + height - r, borderEnd, borderColor);
        graphics.method_25294(x + 1, y + 2, x + 2, y + r, borderColor);
        graphics.method_25294(x + 2, y + 1, x + r, y + 2, borderColor);
        graphics.method_25294(x + width - 2, y + 2, x + width - 1, y + r, borderEnd);
        graphics.method_25294(x + width - r, y + 1, x + width - 2, y + 2, borderEnd);
        graphics.method_25294(x + 1, y + height - r, x + 2, y + height - 2, borderEnd);
        graphics.method_25294(x + 2, y + height - 2, x + r, y + height - 1, borderEnd);
        graphics.method_25294(x + width - 2, y + height - r, x + width - 1, y + height - 2, borderEnd);
        graphics.method_25294(x + width - r, y + height - 2, x + width - 2, y + height - 1, borderEnd);
    }

    private int renderResistances(class_332 graphics, class_327 font, int x, int y) {
        String title = "\u25c6 " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.resistances.title").getString();
        graphics.method_51433(font, title, x, y, -11141121, true);
        y += 12;
        if (!this.analysis.teamImmunities.isEmpty()) {
            String immunePrefix = "  " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.resistances.immune").getString() + " ";
            y = this.renderColoredTypeList(graphics, font, x, y, immunePrefix, this.analysis.teamImmunities, 260);
        }
        if (this.analysis.sharedResistances.isEmpty() && this.analysis.teamImmunities.isEmpty()) {
            graphics.method_51433(font, "  " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.resistances.none").getString(), x, y, 0x888888, false);
            y += 10;
        } else if (!this.analysis.sharedResistances.isEmpty()) {
            String resistPrefix = "  " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.resistances.resist").getString() + " ";
            y = this.renderColoredTypeList(graphics, font, x, y, resistPrefix, this.analysis.sharedResistances.keySet(), 260);
        }
        return y;
    }

    private int renderSuggestions(class_332 graphics, class_327 font, int x, int y) {
        String title = "\u25c6 " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.title").getString();
        graphics.method_51433(font, title, x, y, -43521, true);
        y += 12;
        if (this.analysis.suggestions.isEmpty()) {
            graphics.method_51433(font, "  \u2713 " + class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.balanced").getString(), x, y, 0x88FF88, false);
            y += 10;
        } else {
            for (String suggestion : this.analysis.suggestions) {
                List<String> lines = this.wrapText("  \u2022 " + suggestion, 260, font);
                for (String line : lines) {
                    graphics.method_51433(font, line, x, y, 0xCCCCCC, false);
                    y += 10;
                }
            }
        }
        return y;
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * (1.0f - ratio) + (float)a2 * ratio);
        int r = (int)((float)r1 * (1.0f - ratio) + (float)r2 * ratio);
        int g = (int)((float)g1 * (1.0f - ratio) + (float)g2 * ratio);
        int b = (int)((float)b1 * (1.0f - ratio) + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int darkenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private String formatTypeName(String type) {
        if (type == null || type.isEmpty()) {
            return type;
        }
        ElementalType elementalType = this.getElementalTypeFromName(type);
        if (elementalType != null) {
            try {
                Object displayNameComponent = elementalType.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)elementalType, new Object[0]);
                Object result = displayNameComponent.getClass().getMethod("getString", new Class[0]).invoke(displayNameComponent, new Object[0]);
                if (result != null) {
                    return result.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase();
    }

    private ElementalType getElementalTypeFromName(String typeName) {
        String lowerName;
        if (typeName == null) {
            return null;
        }
        switch (lowerName = typeName.toLowerCase()) {
            case "normal": {
                return ElementalTypes.INSTANCE.getNORMAL();
            }
            case "fire": {
                return ElementalTypes.INSTANCE.getFIRE();
            }
            case "water": {
                return ElementalTypes.INSTANCE.getWATER();
            }
            case "electric": {
                return ElementalTypes.INSTANCE.getELECTRIC();
            }
            case "grass": {
                return ElementalTypes.INSTANCE.getGRASS();
            }
            case "ice": {
                return ElementalTypes.INSTANCE.getICE();
            }
            case "fighting": {
                return ElementalTypes.INSTANCE.getFIGHTING();
            }
            case "poison": {
                return ElementalTypes.INSTANCE.getPOISON();
            }
            case "ground": {
                return ElementalTypes.INSTANCE.getGROUND();
            }
            case "flying": {
                return ElementalTypes.INSTANCE.getFLYING();
            }
            case "psychic": {
                return ElementalTypes.INSTANCE.getPSYCHIC();
            }
            case "bug": {
                return ElementalTypes.INSTANCE.getBUG();
            }
            case "rock": {
                return ElementalTypes.INSTANCE.getROCK();
            }
            case "ghost": {
                return ElementalTypes.INSTANCE.getGHOST();
            }
            case "dragon": {
                return ElementalTypes.INSTANCE.getDRAGON();
            }
            case "dark": {
                return ElementalTypes.INSTANCE.getDARK();
            }
            case "steel": {
                return ElementalTypes.INSTANCE.getSTEEL();
            }
            case "fairy": {
                return ElementalTypes.INSTANCE.getFAIRY();
            }
        }
        return null;
    }

    private List<String> wrapText(String text, int maxWidth, class_327 font) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() > 0 ? String.valueOf(currentLine) + " " + word : word;
            if (font.method_1727(testLine) > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder("    " + word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset - scrollY * 12.0));
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.panelX || mouseX > (double)(this.panelX + 300) || mouseY < (double)this.panelY || mouseY > (double)(this.panelY + 200)) {
            this.method_25419();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
    }

    private static class WeaknessEntry {
        int x;
        int y;
        int width;
        int height;
        String type;
        List<String> pokemonNames;

        WeaknessEntry(int x, int y, int width, int height, String type, List<String> pokemonNames) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.type = type;
            this.pokemonNames = pokemonNames;
        }
    }
}

