/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.gui;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import party.extras.cobblemon.client.gui.TeamAnalysis;

public class TeamAnalyzer {
    private static final Map<String, Set<String>> SUPER_EFFECTIVE = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> NOT_VERY_EFFECTIVE = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> IMMUNE = new HashMap<String, Set<String>>();

    private static void initTypeChart() {
        TeamAnalyzer.addSE("normal", new String[0]);
        TeamAnalyzer.addSE("fire", new String[]{"grass", "ice", "bug", "steel"});
        TeamAnalyzer.addSE("water", new String[]{"fire", "ground", "rock"});
        TeamAnalyzer.addSE("electric", new String[]{"water", "flying"});
        TeamAnalyzer.addSE("grass", new String[]{"water", "ground", "rock"});
        TeamAnalyzer.addSE("ice", new String[]{"grass", "ground", "flying", "dragon"});
        TeamAnalyzer.addSE("fighting", new String[]{"normal", "ice", "rock", "dark", "steel"});
        TeamAnalyzer.addSE("poison", new String[]{"grass", "fairy"});
        TeamAnalyzer.addSE("ground", new String[]{"fire", "electric", "poison", "rock", "steel"});
        TeamAnalyzer.addSE("flying", new String[]{"grass", "fighting", "bug"});
        TeamAnalyzer.addSE("psychic", new String[]{"fighting", "poison"});
        TeamAnalyzer.addSE("bug", new String[]{"grass", "psychic", "dark"});
        TeamAnalyzer.addSE("rock", new String[]{"fire", "ice", "flying", "bug"});
        TeamAnalyzer.addSE("ghost", new String[]{"psychic", "ghost"});
        TeamAnalyzer.addSE("dragon", new String[]{"dragon"});
        TeamAnalyzer.addSE("dark", new String[]{"psychic", "ghost"});
        TeamAnalyzer.addSE("steel", new String[]{"ice", "rock", "fairy"});
        TeamAnalyzer.addSE("fairy", new String[]{"fighting", "dragon", "dark"});
        TeamAnalyzer.addImmune("normal", new String[]{"ghost"});
        TeamAnalyzer.addImmune("ground", new String[]{"electric"});
        TeamAnalyzer.addImmune("flying", new String[]{"ground"});
        TeamAnalyzer.addImmune("ghost", new String[]{"normal", "fighting"});
        TeamAnalyzer.addImmune("dark", new String[]{"psychic"});
        TeamAnalyzer.addImmune("steel", new String[]{"poison"});
        TeamAnalyzer.addImmune("fairy", new String[]{"dragon"});
    }

    private static void addSE(String attacker, String[] defenders) {
        SUPER_EFFECTIVE.put(attacker, new HashSet<String>(Arrays.asList(defenders)));
    }

    private static void addImmune(String defender, String[] attackers) {
        IMMUNE.put(defender, new HashSet<String>(Arrays.asList(attackers)));
    }

    public static TeamAnalysis analyze(List<Pokemon> party) {
        String[] allTypes;
        TeamAnalysis analysis = new TeamAnalysis();
        if (party == null || party.isEmpty()) {
            analysis.suggestions.add(class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.no_pokemon").getString());
            return analysis;
        }
        ArrayList<Pokemon> validPokemon = new ArrayList<Pokemon>();
        for (Pokemon p : party) {
            if (p == null) continue;
            validPokemon.add(p);
        }
        analysis.pokemonCount = validPokemon.size();
        HashSet<String> teamTypes = new HashSet<String>();
        HashMap<String, Integer> weaknessCounts = new HashMap<String, Integer>();
        HashMap<String, List> weaknessPokemonMap = new HashMap<String, List>();
        HashMap<String, Integer> resistanceCounts = new HashMap<String, Integer>();
        HashSet<String> teamImmunities = new HashSet<String>();
        HashSet<String> moveCoverage = new HashSet<String>();
        for (Pokemon pokemon : validPokemon) {
            String[] allTypes2;
            String secType;
            String pokemonName = TeamAnalyzer.getPokemonDisplayName(pokemon);
            String primaryType = pokemon.getPrimaryType().getName().toLowerCase();
            teamTypes.add(primaryType);
            analysis.teamTypes.add(primaryType);
            ElementalType secondaryType = pokemon.getSecondaryType();
            String string = secType = secondaryType != null ? secondaryType.getName().toLowerCase() : null;
            if (secType != null) {
                teamTypes.add(secType);
                analysis.teamTypes.add(secType);
            }
            for (String attackType : allTypes2 = new String[]{"normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
                double multiplier = TeamAnalyzer.getTypeEffectiveness(attackType, primaryType, secType);
                if (multiplier == 0.0) {
                    teamImmunities.add(attackType);
                    continue;
                }
                if (multiplier > 1.0) {
                    weaknessCounts.merge(attackType, 1, Integer::sum);
                    weaknessPokemonMap.computeIfAbsent(attackType, k -> new ArrayList()).add(pokemonName);
                    continue;
                }
                if (!(multiplier < 1.0)) continue;
                resistanceCounts.merge(attackType, 1, Integer::sum);
            }
            try {
                MoveSet moveSet = pokemon.getMoveSet();
                Method getMoves = moveSet.getClass().getMethod("getMoves", new Class[0]);
                Object movesObj = getMoves.invoke((Object)moveSet, new Object[0]);
                if (!(movesObj instanceof Iterable)) continue;
                for (Object moveObj : (Iterable)movesObj) {
                    Move move;
                    if (!(moveObj instanceof Move) || !((move = (Move)moveObj).getTemplate().getPower() > 0.0)) continue;
                    String moveType = move.getTemplate().getElementalType().getName().toLowerCase();
                    moveCoverage.add(moveType);
                    Set<String> seTypes = SUPER_EFFECTIVE.get(moveType);
                    if (seTypes == null) continue;
                    analysis.superEffectiveAgainst.addAll(seTypes);
                }
            }
            catch (Exception exception) {
            }
        }
        analysis.teamImmunities.addAll(teamImmunities);
        for (Map.Entry entry : weaknessCounts.entrySet()) {
            if ((Integer)entry.getValue() < 2) continue;
            analysis.sharedWeaknesses.put((String)entry.getKey(), (Integer)entry.getValue());
            analysis.weaknessPokemonNames.put((String)entry.getKey(), (List)weaknessPokemonMap.get(entry.getKey()));
        }
        analysis.sharedWeaknesses = TeamAnalyzer.sortByValue(analysis.sharedWeaknesses);
        for (Map.Entry entry : resistanceCounts.entrySet()) {
            if ((Integer)entry.getValue() < 2) continue;
            analysis.sharedResistances.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        for (String type : allTypes = new String[]{"normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
            if (analysis.superEffectiveAgainst.contains(type)) continue;
            analysis.missingCoverage.add(type);
        }
        TeamAnalyzer.generateSuggestions(analysis, validPokemon.size());
        return analysis;
    }

    private static String getPokemonDisplayName(Pokemon pokemon) {
        try {
            String nickname;
            String string = nickname = pokemon.getNickname() != null ? pokemon.getNickname().getString() : null;
            if (nickname != null && !nickname.isEmpty()) {
                return nickname;
            }
            return pokemon.getSpecies().getTranslatedName().getString();
        }
        catch (Exception e) {
            return "Pokemon";
        }
    }

    private static Set<String> getWeaknesses(String type1, String type2) {
        String[] allTypes;
        HashSet<String> weaknesses = new HashSet<String>();
        for (String attackType : allTypes = new String[]{"normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
            double multiplier = TeamAnalyzer.getTypeEffectiveness(attackType, type1, type2);
            if (!(multiplier > 1.0)) continue;
            weaknesses.add(attackType);
        }
        return weaknesses;
    }

    private static Set<String> getResistances(String type1, String type2) {
        String[] allTypes;
        HashSet<String> resistances = new HashSet<String>();
        for (String attackType : allTypes = new String[]{"normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
            double multiplier = TeamAnalyzer.getTypeEffectiveness(attackType, type1, type2);
            if (!(multiplier < 1.0)) continue;
            resistances.add(attackType);
        }
        return resistances;
    }

    private static double getTypeEffectiveness(String attackType, String defType1, String defType2) {
        double multiplier = 1.0;
        multiplier *= TeamAnalyzer.getSingleTypeEffectiveness(attackType, defType1);
        if (defType2 != null && !defType2.isEmpty()) {
            multiplier *= TeamAnalyzer.getSingleTypeEffectiveness(attackType, defType2);
        }
        return multiplier;
    }

    private static double getSingleTypeEffectiveness(String attackType, String defType) {
        Set<String> immunities = IMMUNE.get(defType);
        if (immunities != null && immunities.contains(attackType)) {
            return 0.0;
        }
        Set<String> seTypes = SUPER_EFFECTIVE.get(attackType);
        if (seTypes != null && seTypes.contains(defType)) {
            return 2.0;
        }
        for (Map.Entry<String, Set<String>> entry : SUPER_EFFECTIVE.entrySet()) {
            if (entry.getKey().equals(defType) && !entry.getValue().contains(attackType)) continue;
        }
        if (TeamAnalyzer.isResistant(defType, attackType)) {
            return 0.5;
        }
        return 1.0;
    }

    private static boolean isResistant(String defType, String attackType) {
        HashMap resistances = new HashMap();
        resistances.put("fire", Set.of("fire", "grass", "ice", "bug", "steel", "fairy"));
        resistances.put("water", Set.of("fire", "water", "ice", "steel"));
        resistances.put("electric", Set.of("electric", "flying", "steel"));
        resistances.put("grass", Set.of("water", "electric", "grass", "ground"));
        resistances.put("ice", Set.of("ice"));
        resistances.put("fighting", Set.of("bug", "rock", "dark"));
        resistances.put("poison", Set.of("grass", "fighting", "poison", "bug", "fairy"));
        resistances.put("ground", Set.of("poison", "rock"));
        resistances.put("flying", Set.of("grass", "fighting", "bug"));
        resistances.put("psychic", Set.of("fighting", "psychic"));
        resistances.put("bug", Set.of("grass", "fighting", "ground"));
        resistances.put("rock", Set.of("normal", "fire", "poison", "flying"));
        resistances.put("ghost", Set.of("poison", "bug"));
        resistances.put("dragon", Set.of("fire", "water", "electric", "grass"));
        resistances.put("dark", Set.of("ghost", "dark"));
        resistances.put("steel", Set.of("normal", "grass", "ice", "flying", "psychic", "bug", "rock", "dragon", "steel", "fairy"));
        resistances.put("fairy", Set.of("fighting", "bug", "dark"));
        resistances.put("normal", Set.of());
        Set resists = (Set)resistances.get(defType);
        return resists != null && resists.contains(attackType);
    }

    private static void generateSuggestions(TeamAnalysis analysis, int teamSize) {
        for (Map.Entry<String, Integer> entry : analysis.sharedWeaknesses.entrySet()) {
            if (entry.getValue() >= 4) {
                analysis.suggestions.add(class_2561.method_43469((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.critical_weakness", (Object[])new Object[]{entry.getValue(), TeamAnalyzer.formatType(entry.getKey())}).getString());
                continue;
            }
            if (entry.getValue() < 3) continue;
            analysis.suggestions.add(class_2561.method_43469((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.warning_weakness", (Object[])new Object[]{entry.getValue(), TeamAnalyzer.formatType(entry.getKey())}).getString());
        }
        if (!analysis.missingCoverage.isEmpty() && analysis.missingCoverage.size() <= 6) {
            String bestCoverageType = TeamAnalyzer.getBestCoverageType(analysis.missingCoverage);
            if (bestCoverageType != null) {
                analysis.suggestions.add(class_2561.method_43469((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.add_move_type", (Object[])new Object[]{TeamAnalyzer.formatType(bestCoverageType)}).getString());
            }
        } else if (analysis.missingCoverage.size() > 6) {
            analysis.suggestions.add(class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.missing_coverage").getString());
        }
        Set<String> dangerousTypes = Set.of("ground", "fighting", "ice", "fairy", "fire", "water");
        ArrayList<String> unresisted = new ArrayList<String>();
        for (String type : dangerousTypes) {
            if (analysis.sharedResistances.containsKey(type) || analysis.teamImmunities.contains(type)) continue;
            unresisted.add(type);
        }
        if (!unresisted.isEmpty() && unresisted.size() <= 3) {
            for (String type : unresisted) {
                String resistType = TeamAnalyzer.getResistantType(type);
                if (resistType == null || analysis.teamTypes.contains(resistType)) continue;
                analysis.suggestions.add(class_2561.method_43469((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.add_type_for_resist", (Object[])new Object[]{TeamAnalyzer.formatType(resistType), TeamAnalyzer.formatType(type)}).getString());
                break;
            }
        }
        if (analysis.teamImmunities.isEmpty() && teamSize >= 3) {
            analysis.suggestions.add(class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.no_immunities").getString());
            if (!analysis.teamTypes.contains("ground") && !analysis.teamTypes.contains("flying")) {
                analysis.suggestions.add(class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.add_flying_ground").getString());
            } else if (!analysis.teamTypes.contains("ghost") && !analysis.teamTypes.contains("dark")) {
                analysis.suggestions.add(class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.add_ghost_dark").getString());
            }
        }
        if (teamSize < 6) {
            analysis.suggestions.add(class_2561.method_43469((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.team_size", (Object[])new Object[]{teamSize}).getString());
        }
        if (analysis.teamTypes.size() < 4 && teamSize >= 3) {
            analysis.suggestions.add(class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.low_diversity").getString());
        }
        if (teamSize >= 4 && analysis.teamTypes.size() <= 3) {
            analysis.suggestions.add(class_2561.method_43471((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.type_overlap").getString());
        }
        if (!analysis.sharedWeaknesses.isEmpty() && teamSize >= 2) {
            List<String[]> bestCombos = TeamAnalyzer.findBestDualTypes(analysis.sharedWeaknesses.keySet(), analysis.teamTypes, 3);
            for (String[] combo : bestCombos) {
                analysis.suggestions.add(class_2561.method_43469((String)"screen.cobblemon_party_extras.team_analyzer.suggestions.add_dual_type", (Object[])new Object[]{TeamAnalyzer.formatType(combo[0]), TeamAnalyzer.formatType(combo[1])}).getString());
            }
        }
    }

    private static List<String[]> findBestDualTypes(Set<String> teamWeaknesses, Set<String> existingTypes, int maxResults) {
        String[] allTypes = new String[]{"normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"};
        ArrayList<Object[]> scoredCombos = new ArrayList<Object[]>();
        for (int i = 0; i < allTypes.length; ++i) {
            for (int j = i + 1; j < allTypes.length; ++j) {
                String type1 = allTypes[i];
                String type2 = allTypes[j];
                if (existingTypes.contains(type1) && existingTypes.contains(type2)) continue;
                HashSet<String> resists = new HashSet<String>();
                HashSet<String> weakTo = new HashSet<String>();
                for (String attackType : allTypes) {
                    double effectiveness = TeamAnalyzer.getTypeEffectiveness(attackType, type1, type2);
                    if (effectiveness < 1.0) {
                        resists.add(attackType);
                        continue;
                    }
                    if (!(effectiveness > 1.0)) continue;
                    weakTo.add(attackType);
                }
                int resistsWeaknesses = 0;
                for (String weakness : teamWeaknesses) {
                    if (!resists.contains(weakness)) continue;
                    ++resistsWeaknesses;
                }
                int addsWeaknesses = 0;
                for (String weakness : teamWeaknesses) {
                    if (!weakTo.contains(weakness)) continue;
                    ++addsWeaknesses;
                }
                if (resistsWeaknesses < 2 || addsWeaknesses != 0) continue;
                scoredCombos.add(new Object[]{new String[]{type1, type2}, resistsWeaknesses});
            }
        }
        scoredCombos.sort((a, b) -> Integer.compare((Integer)b[1], (Integer)a[1]));
        ArrayList<String[]> results = new ArrayList<String[]>();
        for (int i = 0; i < Math.min(maxResults, scoredCombos.size()); ++i) {
            results.add((String[])((Object[])scoredCombos.get(i))[0]);
        }
        return results;
    }

    private static String getResistantType(String attackType) {
        HashMap<String, String> resisters = new HashMap<String, String>();
        resisters.put("fire", "water");
        resisters.put("water", "water");
        resisters.put("electric", "electric");
        resisters.put("grass", "grass");
        resisters.put("ice", "steel");
        resisters.put("fighting", "fairy");
        resisters.put("poison", "steel");
        resisters.put("ground", "grass");
        resisters.put("flying", "steel");
        resisters.put("psychic", "steel");
        resisters.put("bug", "steel");
        resisters.put("rock", "steel");
        resisters.put("ghost", "dark");
        resisters.put("dragon", "steel");
        resisters.put("dark", "fairy");
        resisters.put("steel", "fire");
        resisters.put("fairy", "steel");
        resisters.put("normal", "steel");
        return (String)resisters.get(attackType);
    }

    private static String getBestCoverageType(Set<String> missingCoverage) {
        HashMap<String, Integer> coverageScore = new HashMap<String, Integer>();
        for (String moveType : SUPER_EFFECTIVE.keySet()) {
            int score = 0;
            Set<String> hits = SUPER_EFFECTIVE.get(moveType);
            if (hits != null) {
                for (String missing : missingCoverage) {
                    if (!hits.contains(missing)) continue;
                    ++score;
                }
            }
            if (score <= 0) continue;
            coverageScore.put(moveType, score);
        }
        String best = null;
        int bestScore = 0;
        for (Map.Entry entry : coverageScore.entrySet()) {
            if ((Integer)entry.getValue() <= bestScore) continue;
            bestScore = (Integer)entry.getValue();
            best = (String)entry.getKey();
        }
        return best;
    }

    private static String getCounterType(String attackType) {
        HashMap<String, String> counters = new HashMap<String, String>();
        counters.put("fire", "water");
        counters.put("water", "grass");
        counters.put("electric", "ground");
        counters.put("grass", "fire");
        counters.put("ice", "fire");
        counters.put("fighting", "flying");
        counters.put("poison", "steel");
        counters.put("ground", "flying");
        counters.put("flying", "electric");
        counters.put("psychic", "dark");
        counters.put("bug", "fire");
        counters.put("rock", "fighting");
        counters.put("ghost", "dark");
        counters.put("dragon", "fairy");
        counters.put("dark", "fairy");
        counters.put("steel", "fire");
        counters.put("fairy", "steel");
        counters.put("normal", "fighting");
        return (String)counters.get(attackType);
    }

    private static String formatTypeList(Set<String> types, int max) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String type : types) {
            if (count >= max) {
                sb.append("...");
                break;
            }
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(TeamAnalyzer.formatType(type));
            ++count;
        }
        return sb.toString();
    }

    private static String formatType(String type) {
        if (type == null || type.isEmpty()) {
            return type;
        }
        ElementalType elementalType = TeamAnalyzer.getElementalTypeFromName(type);
        if (elementalType != null) {
            try {
                return elementalType.getDisplayName().getString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return type.substring(0, 1).toUpperCase() + type.substring(1);
    }

    private static ElementalType getElementalTypeFromName(String typeName) {
        String lowerName;
        if (typeName == null) {
            return null;
        }
        switch (lowerName = typeName.toLowerCase()) {
            case "normal": {
                return ElementalTypes.INSTANCE.getNORMAL();
            }
            case "fire": {
                return ElementalTypes.INSTANCE.getFIRE();
            }
            case "water": {
                return ElementalTypes.INSTANCE.getWATER();
            }
            case "electric": {
                return ElementalTypes.INSTANCE.getELECTRIC();
            }
            case "grass": {
                return ElementalTypes.INSTANCE.getGRASS();
            }
            case "ice": {
                return ElementalTypes.INSTANCE.getICE();
            }
            case "fighting": {
                return ElementalTypes.INSTANCE.getFIGHTING();
            }
            case "poison": {
                return ElementalTypes.INSTANCE.getPOISON();
            }
            case "ground": {
                return ElementalTypes.INSTANCE.getGROUND();
            }
            case "flying": {
                return ElementalTypes.INSTANCE.getFLYING();
            }
            case "psychic": {
                return ElementalTypes.INSTANCE.getPSYCHIC();
            }
            case "bug": {
                return ElementalTypes.INSTANCE.getBUG();
            }
            case "rock": {
                return ElementalTypes.INSTANCE.getROCK();
            }
            case "ghost": {
                return ElementalTypes.INSTANCE.getGHOST();
            }
            case "dragon": {
                return ElementalTypes.INSTANCE.getDRAGON();
            }
            case "dark": {
                return ElementalTypes.INSTANCE.getDARK();
            }
            case "steel": {
                return ElementalTypes.INSTANCE.getSTEEL();
            }
            case "fairy": {
                return ElementalTypes.INSTANCE.getFAIRY();
            }
        }
        return null;
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        list.sort((e1, e2) -> ((Comparable)e2.getValue()).compareTo(e1.getValue()));
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    static {
        TeamAnalyzer.initTypeChart();
    }
}

