/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client.gui;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PokemonWeaknessHelper {
    private static final Map<String, Set<String>> SUPER_EFFECTIVE = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> IMMUNE = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> RESISTANCES = new HashMap<String, Set<String>>();

    private static void initTypeChart() {
        SUPER_EFFECTIVE.put("normal", Set.of());
        SUPER_EFFECTIVE.put("fire", Set.of("grass", "ice", "bug", "steel"));
        SUPER_EFFECTIVE.put("water", Set.of("fire", "ground", "rock"));
        SUPER_EFFECTIVE.put("electric", Set.of("water", "flying"));
        SUPER_EFFECTIVE.put("grass", Set.of("water", "ground", "rock"));
        SUPER_EFFECTIVE.put("ice", Set.of("grass", "ground", "flying", "dragon"));
        SUPER_EFFECTIVE.put("fighting", Set.of("normal", "ice", "rock", "dark", "steel"));
        SUPER_EFFECTIVE.put("poison", Set.of("grass", "fairy"));
        SUPER_EFFECTIVE.put("ground", Set.of("fire", "electric", "poison", "rock", "steel"));
        SUPER_EFFECTIVE.put("flying", Set.of("grass", "fighting", "bug"));
        SUPER_EFFECTIVE.put("psychic", Set.of("fighting", "poison"));
        SUPER_EFFECTIVE.put("bug", Set.of("grass", "psychic", "dark"));
        SUPER_EFFECTIVE.put("rock", Set.of("fire", "ice", "flying", "bug"));
        SUPER_EFFECTIVE.put("ghost", Set.of("psychic", "ghost"));
        SUPER_EFFECTIVE.put("dragon", Set.of("dragon"));
        SUPER_EFFECTIVE.put("dark", Set.of("psychic", "ghost"));
        SUPER_EFFECTIVE.put("steel", Set.of("ice", "rock", "fairy"));
        SUPER_EFFECTIVE.put("fairy", Set.of("fighting", "dragon", "dark"));
        IMMUNE.put("normal", Set.of("ghost"));
        IMMUNE.put("ground", Set.of("electric"));
        IMMUNE.put("flying", Set.of("ground"));
        IMMUNE.put("ghost", Set.of("normal", "fighting"));
        IMMUNE.put("dark", Set.of("psychic"));
        IMMUNE.put("steel", Set.of("poison"));
        IMMUNE.put("fairy", Set.of("dragon"));
        RESISTANCES.put("fire", Set.of("fire", "grass", "ice", "bug", "steel", "fairy"));
        RESISTANCES.put("water", Set.of("fire", "water", "ice", "steel"));
        RESISTANCES.put("electric", Set.of("electric", "flying", "steel"));
        RESISTANCES.put("grass", Set.of("water", "electric", "grass", "ground"));
        RESISTANCES.put("ice", Set.of("ice"));
        RESISTANCES.put("fighting", Set.of("bug", "rock", "dark"));
        RESISTANCES.put("poison", Set.of("grass", "fighting", "poison", "bug", "fairy"));
        RESISTANCES.put("ground", Set.of("poison", "rock"));
        RESISTANCES.put("flying", Set.of("grass", "fighting", "bug"));
        RESISTANCES.put("psychic", Set.of("fighting", "psychic"));
        RESISTANCES.put("bug", Set.of("grass", "fighting", "ground"));
        RESISTANCES.put("rock", Set.of("normal", "fire", "poison", "flying"));
        RESISTANCES.put("ghost", Set.of("poison", "bug"));
        RESISTANCES.put("dragon", Set.of("fire", "water", "electric", "grass"));
        RESISTANCES.put("dark", Set.of("ghost", "dark"));
        RESISTANCES.put("steel", Set.of("normal", "grass", "ice", "flying", "psychic", "bug", "rock", "dragon", "steel", "fairy"));
        RESISTANCES.put("fairy", Set.of("fighting", "bug", "dark"));
        RESISTANCES.put("normal", Set.of());
    }

    public static TypeMatchupResult getFullTypeMatchup(Pokemon pokemon) {
        String[] allTypes;
        TypeMatchupResult result = new TypeMatchupResult();
        String type1 = pokemon.getPrimaryType().getName().toLowerCase();
        ElementalType secondaryType = pokemon.getSecondaryType();
        String type2 = secondaryType != null ? secondaryType.getName().toLowerCase() : null;
        for (String attackType : allTypes = new String[]{"normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
            double multiplier = PokemonWeaknessHelper.getTypeEffectiveness(attackType, type1, type2);
            ElementalType elemType = PokemonWeaknessHelper.getElementalType(attackType);
            if (elemType == null) continue;
            if (multiplier == 0.0) {
                result.immunities.add(elemType);
                continue;
            }
            if (multiplier >= 4.0) {
                result.x4Weaknesses.add(elemType);
                continue;
            }
            if (multiplier >= 2.0) {
                result.x2Weaknesses.add(elemType);
                continue;
            }
            if (multiplier <= 0.25) {
                result.x4Resistances.add(elemType);
                continue;
            }
            if (!(multiplier <= 0.5)) continue;
            result.x2Resistances.add(elemType);
        }
        return result;
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    public static WeaknessResult getWeaknessesCategorized(Pokemon pokemon) {
        String[] allTypes;
        WeaknessResult result = new WeaknessResult();
        String type1 = pokemon.getPrimaryType().getName().toLowerCase();
        ElementalType secondaryType = pokemon.getSecondaryType();
        String type2 = secondaryType != null ? secondaryType.getName().toLowerCase() : null;
        for (String attackType : allTypes = new String[]{"normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
            ElementalType elemType;
            double multiplier = PokemonWeaknessHelper.getTypeEffectiveness(attackType, type1, type2);
            if (multiplier >= 4.0) {
                elemType = PokemonWeaknessHelper.getElementalType(attackType);
                if (elemType == null) continue;
                result.x4Weaknesses.add(elemType);
                continue;
            }
            if (!(multiplier >= 2.0) || (elemType = PokemonWeaknessHelper.getElementalType(attackType)) == null) continue;
            result.x2Weaknesses.add(elemType);
        }
        return result;
    }

    public static List<ElementalType> getWeaknesses(Pokemon pokemon) {
        String[] allTypes;
        ArrayList<ElementalType> weaknesses = new ArrayList<ElementalType>();
        String type1 = pokemon.getPrimaryType().getName().toLowerCase();
        ElementalType secondaryType = pokemon.getSecondaryType();
        String type2 = secondaryType != null ? secondaryType.getName().toLowerCase() : null;
        for (String attackType : allTypes = new String[]{"normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy"}) {
            ElementalType elemType;
            double multiplier = PokemonWeaknessHelper.getTypeEffectiveness(attackType, type1, type2);
            if (!(multiplier > 1.0) || (elemType = PokemonWeaknessHelper.getElementalType(attackType)) == null) continue;
            weaknesses.add(elemType);
        }
        return weaknesses;
    }

    public static ElementalType getElementalType(String typeName) {
        if (typeName == null) {
            return null;
        }
        switch (typeName.toLowerCase()) {
            case "normal": {
                return ElementalTypes.INSTANCE.getNORMAL();
            }
            case "fire": {
                return ElementalTypes.INSTANCE.getFIRE();
            }
            case "water": {
                return ElementalTypes.INSTANCE.getWATER();
            }
            case "electric": {
                return ElementalTypes.INSTANCE.getELECTRIC();
            }
            case "grass": {
                return ElementalTypes.INSTANCE.getGRASS();
            }
            case "ice": {
                return ElementalTypes.INSTANCE.getICE();
            }
            case "fighting": {
                return ElementalTypes.INSTANCE.getFIGHTING();
            }
            case "poison": {
                return ElementalTypes.INSTANCE.getPOISON();
            }
            case "ground": {
                return ElementalTypes.INSTANCE.getGROUND();
            }
            case "flying": {
                return ElementalTypes.INSTANCE.getFLYING();
            }
            case "psychic": {
                return ElementalTypes.INSTANCE.getPSYCHIC();
            }
            case "bug": {
                return ElementalTypes.INSTANCE.getBUG();
            }
            case "rock": {
                return ElementalTypes.INSTANCE.getROCK();
            }
            case "ghost": {
                return ElementalTypes.INSTANCE.getGHOST();
            }
            case "dragon": {
                return ElementalTypes.INSTANCE.getDRAGON();
            }
            case "dark": {
                return ElementalTypes.INSTANCE.getDARK();
            }
            case "steel": {
                return ElementalTypes.INSTANCE.getSTEEL();
            }
            case "fairy": {
                return ElementalTypes.INSTANCE.getFAIRY();
            }
        }
        return null;
    }

    private static double getTypeEffectiveness(String attackType, String defType1, String defType2) {
        double multiplier = 1.0;
        multiplier *= PokemonWeaknessHelper.getSingleTypeEffectiveness(attackType, defType1);
        if (defType2 != null && !defType2.isEmpty()) {
            multiplier *= PokemonWeaknessHelper.getSingleTypeEffectiveness(attackType, defType2);
        }
        return multiplier;
    }

    private static double getSingleTypeEffectiveness(String attackType, String defType) {
        Set<String> immunities = IMMUNE.get(defType);
        if (immunities != null && immunities.contains(attackType)) {
            return 0.0;
        }
        Set<String> seTypes = SUPER_EFFECTIVE.get(attackType);
        if (seTypes != null && seTypes.contains(defType)) {
            return 2.0;
        }
        Set<String> resists = RESISTANCES.get(defType);
        if (resists != null && resists.contains(attackType)) {
            return 0.5;
        }
        return 1.0;
    }

    static {
        PokemonWeaknessHelper.initTypeChart();
    }

    public static class TypeMatchupResult {
        public List<ElementalType> x4Weaknesses = new ArrayList<ElementalType>();
        public List<ElementalType> x2Weaknesses = new ArrayList<ElementalType>();
        public List<ElementalType> x2Resistances = new ArrayList<ElementalType>();
        public List<ElementalType> x4Resistances = new ArrayList<ElementalType>();
        public List<ElementalType> immunities = new ArrayList<ElementalType>();
    }

    public static class WeaknessResult {
        public List<ElementalType> x2Weaknesses = new ArrayList<ElementalType>();
        public List<ElementalType> x4Weaknesses = new ArrayList<ElementalType>();
    }
}

