/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.client.gui.summary.widgets.screens.moves.MoveSwapScreen;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MoveSwapCategoryTracker {
    private static final List<CategoryInfo> categories = new ArrayList<CategoryInfo>();
    private static final Set<MoveSwapScreen.MoveSlot> disabledSlots = new HashSet<MoveSwapScreen.MoveSlot>();
    private static final Set<String> disabledMoveNames = new HashSet<String>();
    private static final Map<String, Integer> futureMoveLevel = new HashMap<String, Integer>();
    private static final Set<Integer> separatorIndices = new HashSet<Integer>();
    private static final Map<Integer, String> separatorLabels = new HashMap<Integer, String>();
    private static final Map<Integer, Integer> separatorColors = new HashMap<Integer, Integer>();
    private static boolean active = false;
    private static boolean filterOpen = false;
    private static String selectedType = null;
    private static int dropdownX = 0;
    private static int dropdownY = 0;
    private static int dropdownWidth = 0;
    private static int dropdownHeight = 0;
    private static final List<String> TYPE_FILTERS = Arrays.asList("all", "normal", "fire", "water", "electric", "grass", "ice", "fighting", "poison", "ground", "flying", "psychic", "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy");
    private static final Set<Object> separatorSlots = new HashSet<Object>();

    public static void clear() {
        categories.clear();
        disabledSlots.clear();
        disabledMoveNames.clear();
        futureMoveLevel.clear();
        separatorIndices.clear();
        separatorLabels.clear();
        separatorColors.clear();
        separatorSlots.clear();
        active = false;
        filterOpen = false;
        MoveSwapCategoryTracker.clearDropdownBounds();
    }

    public static void setActive(boolean isActive) {
        active = isActive;
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isFilterOpen() {
        return filterOpen;
    }

    public static void setFilterOpen(boolean open) {
        filterOpen = open;
    }

    public static void toggleFilterOpen() {
        filterOpen = !filterOpen;
    }

    public static void setDropdownBounds(int x, int y, int width, int height) {
        dropdownX = x;
        dropdownY = y;
        dropdownWidth = width;
        dropdownHeight = height;
    }

    public static void clearDropdownBounds() {
        dropdownX = 0;
        dropdownY = 0;
        dropdownWidth = 0;
        dropdownHeight = 0;
    }

    public static boolean isMouseOverDropdown(int mouseX, int mouseY) {
        if (!filterOpen || dropdownWidth <= 0 || dropdownHeight <= 0) {
            return false;
        }
        return mouseX >= dropdownX && mouseX <= dropdownX + dropdownWidth && mouseY >= dropdownY && mouseY <= dropdownY + dropdownHeight;
    }

    public static List<String> getTypeFilters() {
        return TYPE_FILTERS;
    }

    public static void setSelectedType(String type) {
        selectedType = type == null || "all".equalsIgnoreCase(type) ? null : type.toLowerCase();
    }

    public static String getSelectedType() {
        return selectedType;
    }

    public static String getSelectedTypeLabel() {
        if (selectedType == null) {
            return "All";
        }
        return MoveSwapCategoryTracker.capitalize(selectedType);
    }

    public static boolean isMoveTypeAllowed(MoveTemplate template) {
        if (selectedType == null) {
            return true;
        }
        if (template == null || template.getElementalType() == null) {
            return false;
        }
        String typeName = template.getElementalType().getName();
        return typeName != null && typeName.equalsIgnoreCase(selectedType);
    }

    public static void addCategory(String name, int startIndex, int color) {
        categories.add(new CategoryInfo(name, startIndex, color));
    }

    public static void addSeparator(int index, String label, int color) {
        separatorIndices.add(index);
        separatorLabels.put(index, label);
        separatorColors.put(index, color);
    }

    public static void markAsSeparatorSlot(Object slot) {
        separatorSlots.add(slot);
    }

    public static boolean isSeparatorSlot(Object slot) {
        return separatorSlots.contains(slot);
    }

    public static boolean isSeparator(int index) {
        return separatorIndices.contains(index);
    }

    public static String getSeparatorLabel(int index) {
        return separatorLabels.get(index);
    }

    public static int getSeparatorColor(int index) {
        return separatorColors.getOrDefault(index, 0xFFFFFF);
    }

    public static List<CategoryInfo> getCategories() {
        return categories;
    }

    public static void markAsDisabled(MoveSwapScreen.MoveSlot slot) {
        disabledSlots.add(slot);
        try {
            Field field = slot.getClass().getDeclaredField("move");
            field.setAccessible(true);
            Object move = field.get(slot);
            if (move instanceof MoveTemplate) {
                MoveTemplate template = (MoveTemplate)move;
                disabledMoveNames.add(template.getName().toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void markAsDisabledByName(String moveName) {
        disabledMoveNames.add(moveName.toLowerCase());
    }

    public static void markAsDisabledByName(String moveName, int level) {
        disabledMoveNames.add(moveName.toLowerCase());
        futureMoveLevel.put(moveName.toLowerCase(), level);
    }

    public static int getFutureMoveLevel(String moveName) {
        return futureMoveLevel.getOrDefault(moveName.toLowerCase(), 0);
    }

    public static boolean isDisabled(MoveSwapScreen.MoveSlot slot) {
        return disabledSlots.contains(slot);
    }

    public static boolean isDisabledMove(MoveTemplate template) {
        if (template == null) {
            return false;
        }
        String moveName = template.getName().toLowerCase();
        return disabledMoveNames.contains(moveName);
    }

    private static String capitalize(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    public static class CategoryInfo {
        public final String name;
        public final int startIndex;
        public final int color;

        public CategoryInfo(String name, int startIndex, int color) {
            this.name = name;
            this.startIndex = startIndex;
            this.color = color;
        }
    }
}

