/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LearnsetLoader {
    private static final Map<String, CachedSpeciesData> speciesCache = new HashMap<String, CachedSpeciesData>();
    private static Method getByNameMethod = null;
    private static Object movesInstance = null;

    private static MoveTemplate getMoveByName(String name) {
        try {
            if (getByNameMethod == null) {
                Class<?> movesClass = Class.forName("com.cobblemon.mod.common.api.moves.Moves");
                movesInstance = movesClass.getField("INSTANCE").get(null);
                getByNameMethod = movesClass.getMethod("getByName", String.class);
            }
            return (MoveTemplate)getByNameMethod.invoke(movesInstance, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CachedSpeciesData getLearnset(Pokemon pokemon) {
        return LearnsetLoader.getSpeciesData(pokemon);
    }

    public static CachedSpeciesData getSpeciesData(Pokemon pokemon) {
        String formName;
        String speciesId = pokemon.getSpecies().resourceIdentifier.method_12832();
        String namespace = pokemon.getSpecies().resourceIdentifier.method_12836();
        String cacheKey = namespace + ":" + speciesId + (String)((formName = pokemon.getForm().getName()).equals("Normal") ? "" : "_" + formName);
        CachedSpeciesData cached = speciesCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        cached = LearnsetLoader.loadFromSpeciesJson(namespace, speciesId, formName);
        if (cached != null) {
            speciesCache.put(cacheKey, cached);
            return cached;
        }
        cached = new CachedSpeciesData();
        speciesCache.put(cacheKey, cached);
        return cached;
    }

    private static CachedSpeciesData loadFromSpeciesJson(String namespace, String speciesId, String formName) {
        try {
            String[] generations = new String[]{"generation1", "generation2", "generation3", "generation4", "generation5", "generation6", "generation7", "generation8", "generation9", ""};
            JsonObject speciesJson = null;
            ClassLoader cobblemonLoader = null;
            try {
                Class<?> cobblemonClass = Class.forName("com.cobblemon.mod.common.Cobblemon");
                cobblemonLoader = cobblemonClass.getClassLoader();
            }
            catch (Exception e) {
                return null;
            }
            for (String gen : generations) {
                String path = gen.isEmpty() ? "data/" + namespace + "/species/" + speciesId + ".json" : "data/" + namespace + "/species/" + gen + "/" + speciesId + ".json";
                try (InputStream is2 = cobblemonLoader.getResourceAsStream(path);){
                    if (is2 == null) continue;
                    try (InputStreamReader reader = new InputStreamReader(is2);){
                        speciesJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    }
                    break;
                }
                catch (Exception is2) {
                    // empty catch block
                }
            }
            if (speciesJson == null) {
                speciesJson = LearnsetLoader.loadFromFilesystem(namespace, speciesId, generations);
            }
            if (speciesJson == null) {
                return null;
            }
            CachedSpeciesData data = new CachedSpeciesData();
            JsonArray movesArray = null;
            JsonArray eggGroupsArray = null;
            JsonObject statsObject = null;
            if (!formName.equals("Normal") && speciesJson.has("forms")) {
                JsonArray forms = speciesJson.getAsJsonArray("forms");
                for (JsonElement formElement : forms) {
                    JsonObject formObj = formElement.getAsJsonObject();
                    if (!formObj.has("name") || !formObj.get("name").getAsString().equalsIgnoreCase(formName)) continue;
                    if (formObj.has("moves")) {
                        movesArray = formObj.getAsJsonArray("moves");
                    }
                    if (formObj.has("eggGroups")) {
                        eggGroupsArray = formObj.getAsJsonArray("eggGroups");
                    }
                    if (formObj.has("stats")) {
                        statsObject = formObj.getAsJsonObject("stats");
                    }
                    if (!formObj.has("baseStats")) break;
                    statsObject = formObj.getAsJsonObject("baseStats");
                    break;
                }
            }
            if (movesArray == null && speciesJson.has("moves")) {
                movesArray = speciesJson.getAsJsonArray("moves");
            }
            if (eggGroupsArray == null && speciesJson.has("eggGroups")) {
                eggGroupsArray = speciesJson.getAsJsonArray("eggGroups");
            }
            if (statsObject == null && speciesJson.has("stats")) {
                statsObject = speciesJson.getAsJsonObject("stats");
            }
            if (statsObject == null && speciesJson.has("baseStats")) {
                statsObject = speciesJson.getAsJsonObject("baseStats");
            }
            if (movesArray != null) {
                for (JsonElement moveElement : movesArray) {
                    MoveTemplate template;
                    String moveName;
                    String moveStr = moveElement.getAsString();
                    if (moveStr.startsWith("egg:")) {
                        moveName = moveStr.substring(4);
                        template = LearnsetLoader.getMoveByName(moveName);
                        if (template == null) continue;
                        data.eggMoves.add(template);
                        continue;
                    }
                    if (moveStr.startsWith("tm:")) {
                        moveName = moveStr.substring(3);
                        template = LearnsetLoader.getMoveByName(moveName);
                        if (template == null) continue;
                        data.tmMoves.add(template);
                        continue;
                    }
                    if (!moveStr.startsWith("tutor:") || (template = LearnsetLoader.getMoveByName(moveName = moveStr.substring(6))) == null) continue;
                    data.tutorMoves.add(template);
                }
            }
            if (eggGroupsArray != null) {
                for (JsonElement eggGroupElement : eggGroupsArray) {
                    data.eggGroups.add(eggGroupElement.getAsString());
                }
            }
            if (statsObject != null) {
                LearnsetLoader.readBaseStat(statsObject, data.baseStats, "hp", "hp", "health");
                LearnsetLoader.readBaseStat(statsObject, data.baseStats, "atk", "atk", "attack");
                LearnsetLoader.readBaseStat(statsObject, data.baseStats, "def", "def", "defense", "defence");
                LearnsetLoader.readBaseStat(statsObject, data.baseStats, "spa", "spa", "spatk", "special_attack", "specialattack");
                LearnsetLoader.readBaseStat(statsObject, data.baseStats, "spd", "spd", "spdef", "special_defense", "special_defence", "specialdefense", "specialdefence");
                LearnsetLoader.readBaseStat(statsObject, data.baseStats, "spe", "spe", "speed");
            }
            data.loaded = true;
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearCache() {
        speciesCache.clear();
    }

    private static void readBaseStat(JsonObject statsObject, Map<String, Integer> target, String normalizedKey, String ... keys) {
        if (statsObject == null || target == null || normalizedKey == null || keys == null) {
            return;
        }
        for (String key : keys) {
            if (key == null || !statsObject.has(key)) continue;
            target.put(normalizedKey, statsObject.get(key).getAsInt());
            return;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject loadFromFilesystem(String namespace, String speciesId, String[] generations) {
        List<Path> dataRoots = LearnsetLoader.getLocalDataRoots();
        for (Path dataRoot : dataRoots) {
            for (String gen : generations) {
                Path path = gen.isEmpty() ? dataRoot.resolve(namespace).resolve("species").resolve(speciesId + ".json") : dataRoot.resolve(namespace).resolve("species").resolve(gen).resolve(speciesId + ".json");
                if (!Files.exists(path, new LinkOption[0])) continue;
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    JsonObject jsonObject;
                    try (InputStreamReader reader = new InputStreamReader(is);){
                        jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    }
                    return jsonObject;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static List<Path> getLocalDataRoots() {
        ArrayList<Path> roots = new ArrayList<Path>();
        String userDir = System.getProperty("user.dir");
        String userHome = System.getProperty("user.home");
        LearnsetLoader.addIfExists(roots, LearnsetLoader.resolveDataRoot(userDir, "cobblemon-main", "common", "src", "main", "resources", "data"));
        LearnsetLoader.addIfExists(roots, LearnsetLoader.resolveDataRoot(userDir, "cobblemon-main", "cobblemon-main", "common", "src", "main", "resources", "data"));
        LearnsetLoader.addIfExists(roots, LearnsetLoader.resolveDataRoot(userHome, "Desktop", "cobblemon-main", "common", "src", "main", "resources", "data"));
        LearnsetLoader.addIfExists(roots, LearnsetLoader.resolveDataRoot(userHome, "Desktop", "cobblemon-main", "cobblemon-main", "common", "src", "main", "resources", "data"));
        String envRoot = System.getenv("COBBLEMON_SRC");
        if (envRoot != null && !envRoot.isBlank()) {
            LearnsetLoader.addIfExists(roots, LearnsetLoader.resolveDataRoot(envRoot, "common", "src", "main", "resources", "data"));
            LearnsetLoader.addIfExists(roots, LearnsetLoader.resolveDataRoot(envRoot, "cobblemon-main", "common", "src", "main", "resources", "data"));
        }
        return roots;
    }

    private static Path resolveDataRoot(String base, String ... parts) {
        if (base == null || base.isBlank()) {
            return null;
        }
        return Paths.get(base, parts);
    }

    private static void addIfExists(List<Path> roots, Path path) {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            roots.add(path);
        }
    }

    public static class CachedSpeciesData {
        public final List<MoveTemplate> eggMoves = new ArrayList<MoveTemplate>();
        public final List<MoveTemplate> tmMoves = new ArrayList<MoveTemplate>();
        public final List<MoveTemplate> tutorMoves = new ArrayList<MoveTemplate>();
        public final List<String> eggGroups = new ArrayList<String>();
        public final Map<String, Integer> baseStats = new HashMap<String, Integer>();
        public boolean loaded = false;
    }

    public static class CachedLearnset
    extends CachedSpeciesData {
    }
}

