/*
 * Decompiled with CFR 0.152.
 */
package party.extras.cobblemon.client;

import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class CustomTooltipRenderer {
    private static final int DEFAULT_BACKGROUND = -535816152;
    private static final int DEFAULT_BORDER_START = -11513601;
    private static final int DEFAULT_BORDER_END = -8372032;
    private static final int CORNER_RADIUS = 3;
    private static final int SEPARATOR_COLOR = 0x60FFFFFF;
    private static final int SEPARATOR_ACCENT = 0x40FFFFFF;
    private static final float TOOLTIP_SCALE = 0.85f;

    public static void renderMoveTooltip(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue) {
        CustomTooltipRenderer.renderMoveTooltip(graphics, lines, mouseX, mouseY, typeHue, false);
    }

    public static void renderMoveTooltip(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue, boolean rightOfMouse) {
        int borderColor;
        int y;
        int x;
        if (lines.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        int maxWidth = 0;
        int separatorCount = 0;
        for (class_2561 line : lines) {
            int width = font.method_27525((class_5348)line);
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (!line.getString().isEmpty()) continue;
            ++separatorCount;
        }
        int tooltipWidth = maxWidth + 16;
        int tooltipHeight = lines.size() * 10 + 14;
        if (lines.size() > 1) {
            tooltipHeight += 2;
        }
        tooltipHeight += separatorCount * 2;
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        if (rightOfMouse) {
            x = mouseX + 12;
            y = mouseY - 12;
            if (x + tooltipWidth > screenWidth) {
                x = mouseX - tooltipWidth - 4;
            }
        } else {
            x = mouseX - tooltipWidth - 4;
            y = mouseY - 12;
            if (x < 4) {
                x = mouseX + 12;
            }
        }
        if (y + tooltipHeight > screenHeight) {
            y = screenHeight - tooltipHeight;
        }
        if (y < 4) {
            y = 4;
        }
        int zLevel = 6000;
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int borderStart = borderColor = 0xFF000000 | typeHue & 0xFFFFFF;
        int borderEnd = CustomTooltipRenderer.darkenColor(borderColor, 0.6f);
        CustomTooltipRenderer.drawRoundedTooltipBox(graphics, x, y, tooltipWidth, tooltipHeight, -535816152, borderStart, borderEnd, zLevel);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, (float)(zLevel + 10));
        int textY = y + 6;
        int textX = x + 6;
        int contentWidth = tooltipWidth - 12;
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            String lineStr = line.getString();
            if (lineStr.isEmpty()) {
                CustomTooltipRenderer.drawFancySeparator(graphics, textX, textY + 3, contentWidth, borderStart);
                textY += 12;
                continue;
            }
            graphics.method_51439(font, line, textX, textY, -1, true);
            textY += 10;
            if (i != 0 || lines.size() <= 1) continue;
            CustomTooltipRenderer.drawSubtleSeparator(graphics, textX, textY, contentWidth, borderStart);
            textY += 4;
        }
        graphics.method_51448().method_22909();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static void renderMoveTooltipWithIcons(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue, ElementalType type, DamageCategory category) {
        CustomTooltipRenderer.renderMoveTooltipWithIcons(graphics, lines, mouseX, mouseY, typeHue, type, category, false);
    }

    public static void renderMoveTooltipWithIcons(class_332 graphics, List<class_2561> lines, int mouseX, int mouseY, int typeHue, ElementalType type, DamageCategory category, boolean preferLeft) {
        int borderColor;
        if (lines.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        int iconSpace = 9;
        int maxWidth = 0;
        int separatorCount = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int width = (int)((float)font.method_27525((class_5348)lines.get(i)) * 0.85f);
            if (i == 1) {
                width += iconSpace * 2;
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (!lines.get(i).getString().isEmpty()) continue;
            ++separatorCount;
        }
        int lineHeight = 8;
        int padding = 5;
        int tooltipWidth = maxWidth + padding * 2 + 4;
        int tooltipHeight = lines.size() * lineHeight + padding * 2;
        if (lines.size() > 1) {
            ++tooltipHeight;
        }
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int x = mouseX + 16;
        int y = mouseY - (tooltipHeight += separatorCount * 1) / 2;
        if (preferLeft) {
            x = mouseX - tooltipWidth - 8;
            if (x < 4) {
                x = mouseX + 16;
            }
        } else if (x + tooltipWidth > screenWidth - 4) {
            x = mouseX - tooltipWidth - 8;
        }
        if (y < 4) {
            y = 4;
        }
        if (y + tooltipHeight > screenHeight - 4) {
            y = screenHeight - tooltipHeight - 4;
        }
        int borderStart = borderColor = 0xFF000000 | typeHue & 0xFFFFFF;
        int borderEnd = CustomTooltipRenderer.darkenColor(borderColor, 0.6f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int zLevel = 6000;
        RenderSystem.disableDepthTest();
        CustomTooltipRenderer.drawRoundedTooltipBox(graphics, x, y, tooltipWidth, tooltipHeight, -535816152, borderStart, borderEnd, zLevel);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, (float)(zLevel + 10));
        int textY = y + padding;
        int textX = x + padding;
        int contentWidth = tooltipWidth - padding * 2;
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            String lineStr = line.getString();
            if (lineStr.isEmpty()) {
                CustomTooltipRenderer.drawFancySeparator(graphics, textX, textY + 2, contentWidth, borderStart);
                textY += 10;
                continue;
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)textX, (float)textY, 0.0f);
            graphics.method_51448().method_22905(0.85f, 0.85f, 1.0f);
            if (i == 1 && type != null && category != null) {
                CustomTooltipRenderer.renderTypeIconScaled(graphics, 0, 0, type, 0.85f);
                String typeName = type.getDisplayName().getString();
                int typeIconWidth = 12;
                graphics.method_51433(font, typeName, typeIconWidth, 0, -5592406, true);
                int typeTextWidth = font.method_1727(typeName);
                String separator = " | ";
                graphics.method_51433(font, separator, typeIconWidth + typeTextWidth, 0, -10066330, true);
                int separatorWidth = font.method_1727(separator);
                int categoryIconX = typeIconWidth + typeTextWidth + separatorWidth;
                CustomTooltipRenderer.renderCategoryIconScaled(graphics, categoryIconX, 0, category, 0.85f);
                String categoryName = category.getDisplayName().getString();
                int categoryIconWidth = 16;
                graphics.method_51433(font, categoryName, categoryIconX + categoryIconWidth, 0, -5592406, true);
            } else {
                graphics.method_51439(font, line, 0, 0, -1, true);
            }
            graphics.method_51448().method_22909();
            textY += lineHeight;
            if (i != 0 || lines.size() <= 1) continue;
            CustomTooltipRenderer.drawSubtleSeparator(graphics, textX, textY, contentWidth, borderStart);
            textY += 3;
        }
        graphics.method_51448().method_22909();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    private static void drawFancySeparator(class_332 graphics, int x, int y, int width, int accentColor) {
        int centerX = x + width / 2;
        int lineColor = CustomTooltipRenderer.mixColors(accentColor, 0xFFFFFF, 0.3f);
        int fadeColor = CustomTooltipRenderer.mixColors(accentColor, 0xFFFFFF, 0.1f);
        graphics.method_25296(x + 4, y, centerX - 4, y + 1, fadeColor, lineColor);
        graphics.method_25296(centerX + 4, y, x + width - 4, y + 1, lineColor, fadeColor);
        int dotColor = CustomTooltipRenderer.mixColors(accentColor, -1, 0.5f);
        graphics.method_25294(centerX - 1, y - 1, centerX + 2, y + 2, dotColor);
    }

    private static void drawSubtleSeparator(class_332 graphics, int x, int y, int width, int accentColor) {
        int lineColor = CustomTooltipRenderer.mixColors(accentColor, 0xFFFFFF, 0.2f);
        graphics.method_25296(x, y, x + width, y + 1, lineColor, lineColor);
    }

    private static void renderTypeIcon(class_332 graphics, int x, int y, ElementalType type) {
        class_2960 texture = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/types_small.png");
        int ICON_SIZE = 18;
        int TOTAL_TYPES = 18;
        int RENDER_SIZE = 9;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int u = type.getTextureXMultiplier() * ICON_SIZE;
        graphics.method_25293(texture, x, y, RENDER_SIZE, RENDER_SIZE, (float)u, 0.0f, ICON_SIZE, ICON_SIZE, ICON_SIZE * TOTAL_TYPES, ICON_SIZE);
    }

    private static void renderTypeIconScaled(class_332 graphics, int x, int y, ElementalType type, float scale) {
        class_2960 texture = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/types_small.png");
        int ICON_SIZE = 18;
        int TOTAL_TYPES = 18;
        int RENDER_SIZE = (int)(9.0f / scale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int u = type.getTextureXMultiplier() * ICON_SIZE;
        graphics.method_25293(texture, x, y, RENDER_SIZE, RENDER_SIZE, (float)u, 0.0f, ICON_SIZE, ICON_SIZE, ICON_SIZE * TOTAL_TYPES, ICON_SIZE);
    }

    private static void renderCategoryIcon(class_332 graphics, int x, int y, DamageCategory category) {
        class_2960 texture = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/categories.png");
        int WIDTH = 24;
        int HEIGHT = 16;
        int TOTAL_CATEGORIES = 3;
        int RENDER_WIDTH = 12;
        int RENDER_HEIGHT = 8;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int v = category.getTextureXMultiplier() * HEIGHT;
        graphics.method_25293(texture, x, y, RENDER_WIDTH, RENDER_HEIGHT, 0.0f, (float)v, WIDTH, HEIGHT, WIDTH, HEIGHT * TOTAL_CATEGORIES);
    }

    private static void renderCategoryIconScaled(class_332 graphics, int x, int y, DamageCategory category, float scale) {
        class_2960 texture = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/categories.png");
        int WIDTH = 24;
        int HEIGHT = 16;
        int TOTAL_CATEGORIES = 3;
        int RENDER_WIDTH = (int)(12.0f / scale);
        int RENDER_HEIGHT = (int)(8.0f / scale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int v = category.getTextureXMultiplier() * HEIGHT;
        graphics.method_25293(texture, x, y, RENDER_WIDTH, RENDER_HEIGHT, 0.0f, (float)v, WIDTH, HEIGHT, WIDTH, HEIGHT * TOTAL_CATEGORIES);
    }

    private static void drawRoundedTooltipBox(class_332 graphics, int x, int y, int width, int height, int backgroundColor, int borderStart, int borderEnd, int zLevel) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, (float)zLevel);
        int r = 3;
        graphics.method_25294(x + r, y + r, x + width - r, y + height - r, backgroundColor);
        graphics.method_25294(x + r, y + 1, x + width - r, y + r, backgroundColor);
        graphics.method_25294(x + r, y + height - r, x + width - r, y + height - 1, backgroundColor);
        graphics.method_25294(x + 1, y + r, x + r, y + height - r, backgroundColor);
        graphics.method_25294(x + width - r, y + r, x + width - 1, y + height - r, backgroundColor);
        graphics.method_25294(x + 2, y + 2, x + r, y + r, backgroundColor);
        graphics.method_25294(x + width - r, y + 2, x + width - 2, y + r, backgroundColor);
        graphics.method_25294(x + 2, y + height - r, x + r, y + height - 2, backgroundColor);
        graphics.method_25294(x + width - r, y + height - r, x + width - 2, y + height - 2, backgroundColor);
        graphics.method_25296(x + r, y, x + width - r, y + 1, borderStart, borderEnd);
        graphics.method_25296(x + r, y + height - 1, x + width - r, y + height, borderEnd, borderStart);
        graphics.method_25296(x, y + r, x + 1, y + height - r, borderStart, borderEnd);
        graphics.method_25296(x + width - 1, y + r, x + width, y + height - r, borderEnd, borderStart);
        graphics.method_25294(x + 1, y + 2, x + 2, y + r, borderStart);
        graphics.method_25294(x + 2, y + 1, x + r, y + 2, borderStart);
        int topRightColor = CustomTooltipRenderer.mixColors(borderStart, borderEnd, 0.5f);
        graphics.method_25294(x + width - 2, y + 2, x + width - 1, y + r, topRightColor);
        graphics.method_25294(x + width - r, y + 1, x + width - 2, y + 2, topRightColor);
        int bottomLeftColor = CustomTooltipRenderer.mixColors(borderStart, borderEnd, 0.5f);
        graphics.method_25294(x + 1, y + height - r, x + 2, y + height - 2, bottomLeftColor);
        graphics.method_25294(x + 2, y + height - 2, x + r, y + height - 1, bottomLeftColor);
        graphics.method_25294(x + width - 2, y + height - r, x + width - 1, y + height - 2, borderEnd);
        graphics.method_25294(x + width - r, y + height - 2, x + width - 2, y + height - 1, borderEnd);
        graphics.method_51448().method_22909();
    }

    private static int darkenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int mixColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * (1.0f - ratio) + (float)a2 * ratio);
        int r = (int)((float)r1 * (1.0f - ratio) + (float)r2 * ratio);
        int g = (int)((float)g1 * (1.0f - ratio) + (float)g2 * ratio);
        int b = (int)((float)b1 * (1.0f - ratio) + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

