/*
 * Decompiled with CFR 0.152.
 */
package party.extras.client;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.storage.ClientStorageManager;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import party.extras.config.PartyExtrasConfig;

public class PartyTypeIconRenderer {
    private static final class_2960 TYPES_SMALL = class_2960.method_60655((String)"cobblemon", (String)"textures/gui/types_small.png");
    private static final int TYPE_ICON_SIZE = 18;
    private static final float SCALE = 0.4f;
    private static final int SLOT_HEIGHT = 30;
    private static final int SLOT_SPACING = 4;

    public static void render(class_332 context, float tickDelta) {
        if (!PartyExtrasConfig.get().showPartyTypeIcons) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1755 != null) {
            boolean isChatScreen = minecraft.field_1755 instanceof class_408;
            boolean isBattleGUI = minecraft.field_1755.getClass().getName().contains("BattleGUI");
            if (!isChatScreen && !isBattleGUI) {
                return;
            }
        }
        if (minecraft.field_1690.field_1842 || minecraft.method_53526().method_53536()) {
            return;
        }
        try {
            Class<?> hidePartyBindingClass = Class.forName("com.cobblemon.mod.common.client.keybind.keybinds.HidePartyBinding");
            Field instanceField = hidePartyBindingClass.getDeclaredField("INSTANCE");
            Object instance = instanceField.get(null);
            Field shouldHideField = hidePartyBindingClass.getDeclaredField("shouldHide");
            shouldHideField.setAccessible(true);
            boolean shouldHide = (Boolean)shouldHideField.get(instance);
            if (shouldHide) {
                return;
            }
        }
        catch (Exception hidePartyBindingClass) {
            // empty catch block
        }
        if (CobblemonClient.INSTANCE.getBattle() != null) {
            return;
        }
        try {
            ClientStorageManager storage = CobblemonClient.INSTANCE.getStorage();
            Field partyField = storage.getClass().getDeclaredField("party");
            partyField.setAccessible(true);
            Object party = partyField.get(storage);
            if (party == null) {
                return;
            }
            Method getSlotsMethod = party.getClass().getMethod("getSlots", new Class[0]);
            List slots = (List)getSlotsMethod.invoke(party, new Object[0]);
            if (slots == null || slots.stream().noneMatch(p -> p != null)) {
                return;
            }
            Method getSelectedSlotMethod = storage.getClass().getMethod("getSelectedSlot", new Class[0]);
            int selectedSlot = (Integer)getSelectedSlotMethod.invoke((Object)storage, new Object[0]);
            int totalHeight = slots.size() * 30;
            int midY = minecraft.method_22683().method_4502() / 2;
            int startY = midY - totalHeight / 2 - 10;
            int panelX = 0;
            for (int index = 0; index < slots.size(); ++index) {
                Pokemon pokemon = (Pokemon)slots.get(index);
                if (pokemon == null) continue;
                int selectedOffsetX = selectedSlot == index ? 6 : 0;
                int indexOffsetY = 34 * index;
                int indexY = startY + indexOffsetY;
                ElementalType primaryType = pokemon.getPrimaryType();
                Object secondaryType = pokemon.getSecondaryType();
                String[] randomizedTypes = PartyTypeIconRenderer.getRandomizedTypes(pokemon);
                if (randomizedTypes != null) {
                    ElementalType randSecondary;
                    ElementalType randPrimary = PartyTypeIconRenderer.getElementalType(randomizedTypes[0]);
                    if (randPrimary != null) {
                        primaryType = randPrimary;
                    }
                    secondaryType = randomizedTypes.length > 1 && randomizedTypes[1] != null ? (randSecondary = PartyTypeIconRenderer.getElementalType(randomizedTypes[1])) : null;
                }
                int typeX = secondaryType != null ? panelX + selectedOffsetX + 31 : panelX + selectedOffsetX + 38;
                int typeY = indexY + 17;
                PartyTypeIconRenderer.renderTypeIcon(context, typeX, typeY, primaryType);
                if (secondaryType == null) continue;
                PartyTypeIconRenderer.renderTypeIcon(context, typeX + 7, typeY, secondaryType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderTypeIcon(class_332 context, int x, int y, ElementalType type) {
        try {
            int uOffset = 18 * type.getTextureXMultiplier();
            class_4587 pose = context.method_51448();
            pose.method_22903();
            pose.method_46416(0.0f, 0.0f, 200.0f);
            pose.method_22905(0.4f, 0.4f, 1.0f);
            float scaledX = (float)x / 0.4f;
            float scaledY = (float)y / 0.4f;
            context.method_25290(TYPES_SMALL, (int)scaledX, (int)scaledY, (float)uOffset, 0.0f, 18, 18, 324, 18);
            pose.method_22909();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String[] getRandomizedTypes(Pokemon pokemon) {
        try {
            Class<?> randomizerClientClass = Class.forName("cobblemon.randomizer.client.RandomizerClient");
            Method isRunActive = randomizerClientClass.getMethod("isRunActive", new Class[0]);
            Method isRandomTypes = randomizerClientClass.getMethod("isRandomTypes", new Class[0]);
            boolean runActive = (Boolean)isRunActive.invoke(null, new Object[0]);
            boolean randomTypes = (Boolean)isRandomTypes.invoke(null, new Object[0]);
            if (!runActive || !randomTypes) {
                return null;
            }
            Method getTypesForSpecies = randomizerClientClass.getMethod("getTypesForSpecies", String.class);
            String speciesName = pokemon.getSpecies().getName();
            return (String[])getTypesForSpecies.invoke(null, speciesName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ElementalType getElementalType(String typeName) {
        try {
            Field instanceField = ElementalTypes.class.getDeclaredField("INSTANCE");
            Object instance = instanceField.get(null);
            Method getMethod = instance.getClass().getMethod("get", String.class);
            return (ElementalType)getMethod.invoke(instance, typeName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

