/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.renderer.block;

import com.lunazstudios.cobblefurnies.block.entity.StatueBlockEntity;
import com.lunazstudios.cobblefurnies.client.bbmodel.BBModel;
import com.lunazstudios.cobblefurnies.client.bbmodel.BBRenderer;
import com.lunazstudios.cobblefurnies.registry.CFBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class StatueBlockRenderer
implements class_827<StatueBlockEntity> {
    private static final class_2753 H_FACING = class_2383.field_11177;
    private final Map<String, BBModel> modelCache = new HashMap<String, BBModel>();
    private final Map<String, class_2960> textureCache = new HashMap<String, class_2960>();

    public StatueBlockRenderer(class_5614.class_5615 ctx) {
    }

    public void render(StatueBlockEntity be, float partialTicks, class_4587 ps, class_4597 buffers, int packedLight, int packedOverlay) {
        if (be == null || be.method_10997() == null) {
            return;
        }
        class_2680 state = be.method_11010();
        class_2248 block = state.method_26204();
        String key = this.typeKey(block);
        BBModel model = this.modelCache.computeIfAbsent(key, k -> {
            class_2960 rl = this.modelPathFor((String)k);
            return BBModel.load(rl);
        });
        class_2960 texture = this.textureCache.computeIfAbsent(key, this::texturePathFor);
        ps.method_22903();
        float yawDeg = 0.0f;
        if (state.method_28498((class_2769)H_FACING)) {
            yawDeg = ((class_2350)state.method_11654((class_2769)H_FACING)).method_10144();
        } else if (state.method_28501().stream().anyMatch(p -> Objects.equals(p.method_11899(), "facing"))) {
            try {
                class_2753 prop = state.method_28501().stream().filter(p -> Objects.equals(p.method_11899(), "facing")).findFirst().orElse(null);
                if (prop != null) {
                    yawDeg = ((class_2350)state.method_11654((class_2769)prop)).method_10144();
                }
            }
            catch (Exception prop) {
                // empty catch block
            }
        }
        ps.method_22904(0.5, 0.0, 0.5);
        ps.method_22907(class_7833.field_40716.rotationDegrees(-yawDeg));
        ps.method_22904(-0.5, 0.0, -0.5);
        BBRenderer.Opts opts = BBRenderer.Opts.defaults().clip("idle").loop(false).center(true).autoLight(true).time(0.0f);
        BBRenderer.render(model, be, texture, ps, buffers, partialTicks, packedOverlay, opts);
        ps.method_22909();
    }

    private String typeKey(class_2248 block) {
        if (block == CFBlocks.STATUE_SQUIRTLE.get()) {
            return "squirtle";
        }
        if (block == CFBlocks.STATUE_BULBASAUR.get()) {
            return "bulbasaur";
        }
        if (block == CFBlocks.STATUE_CHARMANDER.get()) {
            return "charmander";
        }
        if (block == CFBlocks.STATUE_PIKACHU.get()) {
            return "pikachu";
        }
        return "ancient";
    }

    private class_2960 modelPathFor(String key) {
        return class_2960.method_60655((String)"cobblefurnies", (String)("models/bb/statue_" + key + ".bbs.json"));
    }

    private class_2960 texturePathFor(String key) {
        return class_2960.method_60655((String)"cobblefurnies", (String)("textures/block/statue/statue_" + key + ".png"));
    }
}

