/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.client.bbmodel;

import com.lunazstudios.cobblefurnies.client.bbmodel.BBAnimSampler;
import com.lunazstudios.cobblefurnies.client.bbmodel.BBModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.joml.Vector3f;

public class BBRenderer {
    private static final float PX = 0.0625f;

    private static float convX(float x) {
        return -x;
    }

    private static float convY(float y) {
        return y;
    }

    private static float convZ(float z) {
        return -z;
    }

    private static float convTX(float x) {
        return -x;
    }

    private static float convTY(float y) {
        return y;
    }

    private static float convTZ(float z) {
        return -z;
    }

    public static void render(BBModel model, class_2586 be, class_2960 texture, class_4587 ps, class_4597 buffers, float partialTicks, int packedOverlay, Opts opts) {
        float timeSec;
        if (be == null || be.method_10997() == null) {
            return;
        }
        class_1937 level = be.method_10997();
        class_2338 pos = be.method_11016();
        float f = timeSec = opts.fixedTimeSec >= 0.0f ? opts.fixedTimeSec : BBRenderer.computeTime(level, pos, partialTicks, model, opts.clip, opts.loop);
        int packedLight = opts.autoLight && opts.lightOverride < 0 ? BBRenderer.getMaxNeighborLight(level, pos) : (opts.lightOverride >= 0 ? opts.lightOverride : class_765.method_23687((int)0, (int)0));
        ps.method_22903();
        if (opts.centerOnBlock) {
            ps.method_22904(0.5, 0.0, 0.5);
        }
        class_1921 rt = class_1921.method_23578((class_2960)texture);
        class_4588 vc = buffers.getBuffer(rt);
        String clipName = opts.clip;
        BBModel.AnimationClip clip = model.clips.get(clipName);
        HashMap<String, Vector3f> rot0 = new HashMap<String, Vector3f>();
        HashMap<String, Vector3f> pos0 = new HashMap<String, Vector3f>();
        if (clip != null) {
            for (Map.Entry entry : clip.tracks.entrySet()) {
                BBModel.AnimTrack t = (BBModel.AnimTrack)entry.getValue();
                if (t.rotate != null && !t.rotate.isEmpty()) {
                    rot0.put((String)entry.getKey(), BBAnimSampler.sampleRotate(t.rotate, 0.0f));
                }
                if (t.translate == null || t.translate.isEmpty()) continue;
                pos0.put((String)entry.getKey(), BBAnimSampler.sampleTranslate(t.translate, 0.0f));
            }
        }
        for (BBModel.Group group : model.roots) {
            BBRenderer.renderGroupRecursive(model, clip, timeSec, rot0, pos0, group, ps, vc, packedLight, packedOverlay, model.texW, model.texH);
        }
        ps.method_22909();
    }

    private static float computeTime(class_1937 level, class_2338 pos, float partialTicks, BBModel model, String clipName, boolean loop) {
        long gt = level.method_8510();
        float baseSec = ((float)gt + partialTicks) / 20.0f;
        float duration = 0.0f;
        BBModel.AnimationClip clip = model.clips.get(clipName);
        if (clip != null) {
            duration = clip.durationSec;
        }
        long h = pos.method_10063();
        float offsetSec = (float)((h ^ h >>> 32) & 0xFFL) / 255.0f * (duration > 0.0f ? duration : 2.0f);
        if (loop && duration > 0.0f) {
            return (baseSec + offsetSec) % duration;
        }
        return duration > 0.0f ? Math.min(baseSec + offsetSec, duration) : baseSec + offsetSec;
    }

    private static int getMaxNeighborLight(class_1937 level, class_2338 pos) {
        int block = level.method_8314(class_1944.field_9282, pos);
        int sky = level.method_8314(class_1944.field_9284, pos);
        for (class_2350 d : class_2350.values()) {
            class_2338 n = pos.method_10093(d);
            block = Math.max(block, level.method_8314(class_1944.field_9282, n));
            sky = Math.max(sky, level.method_8314(class_1944.field_9284, n));
        }
        return class_765.method_23687((int)block, (int)sky);
    }

    private static void renderGroupRecursive(BBModel model, BBModel.AnimationClip clip, float tSec, Map<String, Vector3f> rot0, Map<String, Vector3f> pos0, BBModel.Group g, class_4587 ps, class_4588 vc, int light, int overlay, int texW, int texH) {
        float rz;
        float ry;
        float rx;
        BBModel.AnimTrack track;
        ps.method_22903();
        ps.method_46416(BBRenderer.convTX(g.origin.x) * 0.0625f, BBRenderer.convTY(g.origin.y) * 0.0625f, BBRenderer.convTZ(g.origin.z) * 0.0625f);
        Vector3f rotAnim = null;
        Vector3f transAnim = null;
        if (clip != null && (track = clip.tracks.get(g.name)) != null) {
            if (track.rotate != null && !track.rotate.isEmpty()) {
                rotAnim = BBAnimSampler.sampleRotate(track.rotate, tSec);
            }
            if (track.translate != null && !track.translate.isEmpty()) {
                transAnim = BBAnimSampler.sampleTranslate(track.translate, tSec);
            }
        }
        if (rotAnim != null) {
            rx = BBRenderer.convX(rotAnim.x);
            ry = BBRenderer.convY(rotAnim.y);
            rz = BBRenderer.convZ(rotAnim.z);
        } else {
            rx = BBRenderer.convX(g.rotateDeg.x);
            ry = BBRenderer.convY(g.rotateDeg.y);
            rz = BBRenderer.convZ(g.rotateDeg.z);
        }
        ps.method_22907(class_7833.field_40718.rotationDegrees(rz));
        ps.method_22907(class_7833.field_40716.rotationDegrees(ry));
        ps.method_22907(class_7833.field_40714.rotationDegrees(rx));
        if (transAnim != null) {
            ps.method_46416(BBRenderer.convTX(transAnim.x) * 0.0625f, BBRenderer.convTY(transAnim.y) * 0.0625f, BBRenderer.convTZ(transAnim.z) * 0.0625f);
        }
        ps.method_46416(-BBRenderer.convTX(g.origin.x) * 0.0625f, -BBRenderer.convTY(g.origin.y) * 0.0625f, -BBRenderer.convTZ(g.origin.z) * 0.0625f);
        for (BBModel.Cube c : g.cubes) {
            BBRenderer.renderCubeLocal(c, ps, vc, light, overlay, texW, texH);
        }
        for (BBModel.Group child : g.children) {
            BBRenderer.renderGroupRecursive(model, clip, tSec, rot0, pos0, child, ps, vc, light, overlay, texW, texH);
        }
        ps.method_22909();
    }

    private static void renderCubeLocal(BBModel.Cube c, class_4587 ps, class_4588 vc, int light, int overlay, int texW, int texH) {
        ps.method_22903();
        ps.method_46416(BBRenderer.convTX(c.origin.x) * 0.0625f, BBRenderer.convTY(c.origin.y) * 0.0625f, BBRenderer.convTZ(c.origin.z) * 0.0625f);
        float x1 = BBRenderer.convTX(c.from.x - c.origin.x) * 0.0625f;
        float y1 = BBRenderer.convTY(c.from.y - c.origin.y) * 0.0625f;
        float z1 = BBRenderer.convTZ(c.from.z - c.origin.z) * 0.0625f;
        float x2 = BBRenderer.convTX(c.from.x + c.size.x - c.origin.x) * 0.0625f;
        float y2 = BBRenderer.convTY(c.from.y + c.size.y - c.origin.y) * 0.0625f;
        float z2 = BBRenderer.convTZ(c.from.z + c.size.z - c.origin.z) * 0.0625f;
        if (c.offset != 0.0f) {
            float off = c.offset * 0.0625f;
            x1 -= off;
            y1 -= off;
            z1 -= off;
            x2 += off;
            y2 += off;
            z2 += off;
        }
        BBRenderer.drawFace(ps, vc, light, overlay, texW, texH, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1, c.faceUV.get("front"));
        BBRenderer.drawFace(ps, vc, light, overlay, texW, texH, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2, c.faceUV.get("back"));
        BBRenderer.drawFace(ps, vc, light, overlay, texW, texH, x2, y1, z1, x2, y1, z2, x2, y2, z2, x2, y2, z1, c.faceUV.get("right"));
        BBRenderer.drawFace(ps, vc, light, overlay, texW, texH, x1, y1, z2, x1, y1, z1, x1, y2, z1, x1, y2, z2, c.faceUV.get("left"));
        BBRenderer.drawFace(ps, vc, light, overlay, texW, texH, x1, y2, z1, x2, y2, z1, x2, y2, z2, x1, y2, z2, c.faceUV.get("top"));
        BBRenderer.drawFace(ps, vc, light, overlay, texW, texH, x1, y1, z2, x2, y1, z2, x2, y1, z1, x1, y1, z1, c.faceUV.get("bottom"));
        ps.method_22909();
    }

    private static void drawFace(class_4587 ps, class_4588 vc, int packedLight, int packedOverlay, int texW, int texH, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, BBModel.UVRect uv) {
        if (uv == null) {
            return;
        }
        float u1 = (float)uv.u1 / (float)texW;
        float v1 = (float)uv.v1 / (float)texH;
        float u2 = (float)uv.u2 / (float)texW;
        float v2 = (float)uv.v2 / (float)texH;
        class_4587.class_4665 pose = ps.method_23760();
        float ay = y2 - y1;
        float bz = z4 - z1;
        float az = z2 - z1;
        float by = y4 - y1;
        float nx = ay * bz - az * by;
        float bx = x4 - x1;
        float ax = x2 - x1;
        float ny = az * bx - ax * bz;
        float nz = ax * by - ay * bx;
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len > 1.0E-6f) {
            nx /= len;
            ny /= len;
            nz /= len;
        } else {
            ny = 0.0f;
            nx = 0.0f;
            nz = 1.0f;
        }
        BBRenderer.emit(vc, pose, x1, y1, z1, u1, v2, packedOverlay, packedLight, nx, ny, nz);
        BBRenderer.emit(vc, pose, x2, y2, z2, u2, v2, packedOverlay, packedLight, nx, ny, nz);
        BBRenderer.emit(vc, pose, x3, y3, z3, u2, v1, packedOverlay, packedLight, nx, ny, nz);
        BBRenderer.emit(vc, pose, x4, y4, z4, u1, v1, packedOverlay, packedLight, nx, ny, nz);
    }

    private static void emit(class_4588 vc, class_4587.class_4665 pose, float x, float y, float z, float u, float v, int overlay, int light, float nx, float ny, float nz) {
        vc.method_56824(pose, x, y, z).method_22913(u, v).method_22922(overlay).method_60803(light).method_60831(pose, -nx, -ny, -nz).method_60832(255);
    }

    public static final class Opts {
        public String clip = "idle";
        public boolean loop = true;
        public boolean centerOnBlock = true;
        public boolean autoLight = true;
        public float fixedTimeSec = -1.0f;
        public int lightOverride = -1;

        public Opts clip(String c) {
            this.clip = c;
            return this;
        }

        public Opts loop(boolean v) {
            this.loop = v;
            return this;
        }

        public Opts center(boolean v) {
            this.centerOnBlock = v;
            return this;
        }

        public Opts autoLight(boolean v) {
            this.autoLight = v;
            return this;
        }

        public Opts time(float sec) {
            this.fixedTimeSec = sec;
            return this;
        }

        public Opts light(int packed) {
            this.lightOverride = packed;
            return this;
        }

        public static Opts defaults() {
            return new Opts();
        }
    }
}

