/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.BiomeAccessor;
import dev.worldgen.lithostitched.mixin.common.MappedRegistryAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.util.BiomeClimate;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9248;

public record ReplaceClimateModifier(int priority, class_6885<class_1959> biomes, BiomeClimate climateSettings) implements Modifier
{
    public static final MapCodec<ReplaceClimateModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PRIORITY_DEFAULT.forGetter(ReplaceClimateModifier::priority), (App)class_1959.field_26750.fieldOf("biomes").forGetter(ReplaceClimateModifier::biomes), (App)BiomeClimate.CODEC.fieldOf("climate").forGetter(ReplaceClimateModifier::climateSettings)).apply((Applicative)instance, ReplaceClimateModifier::new));

    @Override
    public void applyModifier(class_5455 registryAccess) {
        List biomes = this.biomes().method_40239().toList();
        class_2378 registry = registryAccess.method_30530(class_7924.field_41236);
        for (class_6880 entry : biomes.stream().toList()) {
            this.applyModifier((class_1959)entry.comp_349());
            if (!entry.method_40230().isPresent()) continue;
            class_5321 key = (class_5321)entry.method_40230().get();
            Optional knownPackInfo = registry.method_57058(key);
            knownPackInfo.ifPresent(registrationInfo -> ((MappedRegistryAccessor)registry).lithostitched$getRegistrationInfos().put(key, new class_9248(Optional.empty(), registrationInfo.comp_2355())));
        }
    }

    @Override
    public void applyModifier() {
    }

    public void applyModifier(class_1959 biome) {
        class_1959.class_5482 originalClimate = ((BiomeAccessor)biome).getClimateSettings();
        Boolean hasPrecipitation = this.climateSettings.hasPrecipitation().orElse(originalClimate.comp_1187());
        Float temperature = this.climateSettings.temperature().orElse(Float.valueOf(originalClimate.comp_844()));
        class_1959.class_5484 temperatureModifier = this.climateSettings.temperatureModifier().orElse(originalClimate.comp_845());
        Float downfall = this.climateSettings.downfall().orElse(Float.valueOf(originalClimate.comp_846()));
        ((BiomeAccessor)biome).setClimateSettings(new class_1959.class_5482(hasPrecipitation.booleanValue(), temperature.floatValue(), temperatureModifier, downfall.floatValue()));
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

