/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature;

import dev.worldgen.lithostitched.util.MathUtils;
import dev.worldgen.lithostitched.worldgen.feature.config.LargeDripstoneConfig;
import dev.worldgen.lithostitched.worldgen.feature.util.DripstoneUtils;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;

public class LargeDripstoneFeature
extends class_3031<LargeDripstoneConfig> {
    public static LargeDripstoneFeature FEATURE = new LargeDripstoneFeature();

    public LargeDripstoneFeature() {
        super(LargeDripstoneConfig.CODEC);
    }

    public boolean method_13151(class_5821<LargeDripstoneConfig> context) {
        Object t;
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        LargeDripstoneConfig config = (LargeDripstoneConfig)context.method_33656();
        class_5819 random = context.method_33654();
        if (!DripstoneUtils.isEmptyOrWater((class_1936)level, origin)) {
            return false;
        }
        Optional column = class_5721.method_32982((class_3746)level, (class_2338)origin, (int)config.floorToCeilingSearchRange(), DripstoneUtils::isEmptyOrWater, state -> DripstoneUtils.isReplaceableOrLava(state, config.replaceableBlocks()));
        if (column.isPresent() && (t = column.get()) instanceof class_5721.class_5723) {
            class_5721.class_5723 range = (class_5721.class_5723)t;
            if (range.method_32992() < 4) {
                return false;
            }
            int unclampedRadius = (int)((float)range.method_32992() * config.maxColumnRadiusToCaveHeightRatio());
            int maxRadius = class_3532.method_15340((int)unclampedRadius, (int)config.columnRadius().method_35009(), (int)config.columnRadius().method_35011());
            int radius = class_3532.method_32751((class_5819)random, (int)config.columnRadius().method_35009(), (int)maxRadius);
            LargeDripstone ceilingDripstone = LargeDripstoneFeature.makeDripstone(config.stateProvider(), random, origin.method_33096(range.method_32990() - 1), false, radius, config.stalactiteBluntness(), config.heightScale());
            LargeDripstone floorDripstone = LargeDripstoneFeature.makeDripstone(config.stateProvider(), random, origin.method_33096(range.method_32991() + 1), true, radius, config.stalagmiteBluntness(), config.heightScale());
            WindOffsetter windOffsetter = ceilingDripstone.isSuitableForWind(config) && floorDripstone.isSuitableForWind(config) ? new WindOffsetter(origin.method_10264(), random, config.windSpeed()) : WindOffsetter.noWind();
            boolean $$14 = ceilingDripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level, windOffsetter);
            boolean $$15 = floorDripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level, windOffsetter);
            if ($$14) {
                ceilingDripstone.placeBlocks(level, random, windOffsetter);
            }
            if ($$15) {
                floorDripstone.placeBlocks(level, random, windOffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeDripstone makeDripstone(class_4651 stateProvider, class_5819 random, class_2338 root, boolean pointingUp, int radius, class_5863 bluntness, class_5863 scale) {
        return new LargeDripstone(stateProvider, root, pointingUp, radius, bluntness.method_33920(random), scale.method_33920(random));
    }

    static final class LargeDripstone {
        private final class_4651 stateProvider;
        private class_2338 root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeDripstone(class_4651 stateProvider, class_2338 root, boolean pointingUp, int radius, double bluntness, double scale) {
            this.stateProvider = stateProvider;
            this.root = root;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(class_5281 $$0, WindOffsetter $$1) {
            while (this.radius > 1) {
                class_2338.class_2339 $$2 = this.root.method_25503();
                int $$3 = Math.min(10, this.getHeight());
                for (int $$4 = 0; $$4 < $$3; ++$$4) {
                    if ($$0.method_8320((class_2338)$$2).method_27852(class_2246.field_10164)) {
                        return false;
                    }
                    if (DripstoneUtils.isCircleMostlyEmbeddedInStone($$0, $$1.offset((class_2338)$$2), this.radius)) {
                        this.root = $$2;
                        return true;
                    }
                    $$2.method_10098(this.pointingUp ? class_2350.field_11033 : class_2350.field_11036);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float $$0) {
            return (int)DripstoneUtils.getDripstoneHeight($$0, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(class_5281 level, class_5819 random, WindOffsetter windOffsetter) {
            for (int x = -this.radius; x <= this.radius; ++x) {
                block1: for (int z = -this.radius; z <= this.radius; ++z) {
                    int height;
                    float rootDistance = class_3532.method_15355((float)(x * x + z * z));
                    if (rootDistance > (float)this.radius || (height = this.getHeightAtRadius(rootDistance)) <= 0) continue;
                    if ((double)random.method_43057() < 0.2) {
                        height = (int)((float)height * class_3532.method_32750((class_5819)random, (float)0.8f, (float)1.0f));
                    }
                    class_2338.class_2339 pos = this.root.method_10069(x, 0, z).method_25503();
                    boolean placedBlock = false;
                    int maxY = this.pointingUp ? level.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260()) : Integer.MAX_VALUE;
                    for (int $$10 = 0; $$10 < height && pos.method_10264() < maxY; ++$$10) {
                        class_2338 dripstonePos = windOffsetter.offset((class_2338)pos);
                        if (DripstoneUtils.isEmptyOrWaterOrLava((class_1936)level, dripstonePos)) {
                            placedBlock = true;
                            level.method_8652(dripstonePos, this.stateProvider.method_23455(random, dripstonePos), 2);
                        } else if (placedBlock && level.method_8320(dripstonePos).method_26164(class_3481.field_25806)) continue block1;
                        pos.method_10098(this.pointingUp ? class_2350.field_11036 : class_2350.field_11033);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargeDripstoneConfig $$0) {
            return this.radius >= $$0.minRadiusForWind() && this.bluntness >= (double)$$0.minBluntnessForWind();
        }
    }

    static final class WindOffsetter {
        private final int originY;
        private final class_243 windSpeed;

        WindOffsetter(int y, class_5819 random, class_5863 $$2) {
            this.originY = y;
            float $$3 = $$2.method_33920(random);
            float $$4 = class_3532.method_32750((class_5819)random, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new class_243((double)(MathUtils.cos($$4) * $$3), 0.0, (double)(MathUtils.sin($$4) * $$3));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        class_2338 offset(class_2338 $$0) {
            if (this.windSpeed == null) {
                return $$0;
            }
            int $$1 = this.originY - $$0.method_10264();
            class_243 $$2 = this.windSpeed.method_1021((double)$$1);
            return $$0.method_10069(class_3532.method_15357((double)$$2.field_1352), 0, class_3532.method_15357((double)$$2.field_1350));
        }
    }
}

