/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.render;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.codec.sizer.LayerCodec;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4013;
import org.jetbrains.annotations.NotNull;

public class LayerDataLoader
implements class_4013 {
    private static final String DIRECTORY = "msd_sizer";
    public static final HashMap<String, SizerRegStruct> LAYER_REGISTRY = new HashMap();

    public static LayerCodec.Settings getSettings(Pokemon pokemon, String aspect) {
        String name = pokemon.getSpecies().resourceIdentifier.method_12832();
        String formName = pokemon.getForm().getName();
        SizerRegStruct reg = LAYER_REGISTRY.get(name);
        if (reg == null) {
            return null;
        }
        return reg.getSettings(formName, aspect);
    }

    public static void load() {
        class_3300 rm = class_310.method_1551().method_1478();
        LAYER_REGISTRY.clear();
        Set resources = rm.method_14488(DIRECTORY, path -> path.method_12832().endsWith(".json")).keySet();
        for (class_2960 id : resources) {
            try {
                InputStream stream = ((class_3298)rm.method_14486(id).get()).method_14482();
                try {
                    LayerCodec codec = (LayerCodec)LayerCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new InputStreamReader(stream))).result().orElseThrow();
                    LAYER_REGISTRY.putIfAbsent(codec.pokemon(), new SizerRegStruct());
                    SizerRegStruct sizerRegStruct = LAYER_REGISTRY.get(codec.pokemon());
                    for (String form : codec.size_config().keySet()) {
                        for (Map.Entry<String, LayerCodec.Settings> aspectSetting : codec.size_config().get(form).entrySet()) {
                            sizerRegStruct.addForm(form, aspectSetting.getKey(), aspectSetting.getValue());
                        }
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                MegaShowdown.LOGGER.error("Failed loading layer JSON: {}", (Object)id, (Object)e);
            }
        }
        MegaShowdown.LOGGER.info("Loaded {} custom layer data", (Object)LAYER_REGISTRY.size());
    }

    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
        LayerDataLoader.load();
        return super.method_25931(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
    }

    public void method_14491(class_3300 resourceManager) {
    }

    @NotNull
    public String method_22322() {
        return "mega_showdown";
    }

    public static class SizerRegStruct {
        private final HashMap<String, HashMap<String, LayerCodec.Settings>> settingsHashMap = new HashMap();

        public void addForm(String formName, String aspect, LayerCodec.Settings settings) {
            HashMap<String, LayerCodec.Settings> map = this.settingsHashMap.getOrDefault(formName, new HashMap());
            map.put(aspect, settings);
            this.settingsHashMap.putIfAbsent(formName, map);
        }

        public LayerCodec.Settings getSettings(String formName, String aspect) {
            return (LayerCodec.Settings)this.settingsHashMap.getOrDefault(formName, new HashMap()).get(aspect);
        }
    }
}

