/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec.particles;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.codec.particles.AnimationData;
import com.github.yajatkaul.mega_showdown.codec.particles.SoundCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public record MinecraftParticle(Optional<String> particle_apply, Optional<String> particle_revert, Optional<SoundCodec> sound_apply, Optional<SoundCodec> sound_revert, Optional<Float> particle_apply_amplifier, Optional<Float> particle_revert_amplifier, Optional<AnimationData> animations) {
    public static final Codec<MinecraftParticle> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("particle_apply").forGetter(MinecraftParticle::particle_apply), (App)Codec.STRING.optionalFieldOf("particle_revert").forGetter(MinecraftParticle::particle_revert), (App)SoundCodec.CODEC.optionalFieldOf("sound_apply").forGetter(MinecraftParticle::sound_apply), (App)SoundCodec.CODEC.optionalFieldOf("sound_revert").forGetter(MinecraftParticle::sound_revert), (App)Codec.FLOAT.optionalFieldOf("particle_apply_amplifier").forGetter(MinecraftParticle::particle_apply_amplifier), (App)Codec.FLOAT.optionalFieldOf("particle_revert_amplifier").forGetter(MinecraftParticle::particle_revert_amplifier), (App)AnimationData.CODEC.optionalFieldOf("animations").forGetter(MinecraftParticle::animations)).apply((Applicative)instance, MinecraftParticle::new));

    public void apply(PokemonEntity context) {
        if (context == null) {
            return;
        }
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            this.animations.ifPresent(animation -> animation.applyAnimations(context));
            this.sound_apply.ifPresent(sound_apply -> sound_apply.play(context));
            this.particle_apply.ifPresent(particle_apply -> {
                String[] partsParticle = particle_apply.split(":");
                class_2960 custom_particle_id = class_2960.method_60655((String)partsParticle[0], (String)partsParticle[1]);
                class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(custom_particle_id);
                double entityWidth = context.method_17681();
                double entityHeight = context.method_17682();
                int baseParticleCount = (int)(100.0 * entityWidth * entityHeight);
                float amplifier = 1.0f;
                if (this.particle_apply_amplifier.isPresent()) {
                    amplifier = Math.max(1.0f, this.particle_apply_amplifier.get().floatValue());
                }
                float particleCount = (float)baseParticleCount * amplifier;
                double radius = entityWidth * (0.8 + (double)amplifier * 0.1);
                if (particleType instanceof class_2394) {
                    class_2394 particle = (class_2394)particleType;
                    int i = 0;
                    while ((float)i < particleCount) {
                        double angle = Math.random() * 2.0 * Math.PI;
                        double xOffset = Math.cos(angle) * radius;
                        double zOffset = Math.sin(angle) * radius;
                        double yOffset = Math.random() * entityHeight;
                        serverLevel.method_14199(particle, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
                        ++i;
                    }
                } else {
                    MegaShowdown.LOGGER.error("Invalid Particle Apply used for pokemons: {}, particle id: {}", (Object)context.getPokemon().getSpecies().getName(), particle_apply);
                }
            });
        }
    }

    public void revert(PokemonEntity context) {
        if (context == null) {
            return;
        }
        class_1937 class_19372 = context.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_243 entityPos = context.method_19538();
            this.animations.ifPresent(animation -> animation.revertAnimations(context));
            this.sound_revert.ifPresent(sound_revert -> sound_revert.play(context));
            this.particle_revert.ifPresent(particle_revert -> {
                String[] partsParticle = particle_revert.split(":");
                class_2960 custom_particle_id = class_2960.method_60655((String)partsParticle[0], (String)partsParticle[1]);
                class_2396 particleType = (class_2396)class_7923.field_41180.method_10223(custom_particle_id);
                double entityWidth = context.method_17681();
                double entityHeight = context.method_17682();
                int baseParticleCount = (int)(100.0 * entityWidth * entityHeight);
                float amplifier = 1.0f;
                if (this.particle_revert_amplifier.isPresent()) {
                    amplifier = Math.max(1.0f, this.particle_revert_amplifier.get().floatValue());
                }
                float particleCount = (float)baseParticleCount * amplifier;
                double radius = entityWidth * (0.8 + (double)amplifier * 0.1);
                if (particleType instanceof class_2394) {
                    class_2394 particle = (class_2394)particleType;
                    int i = 0;
                    while ((float)i < particleCount) {
                        double angle = Math.random() * 2.0 * Math.PI;
                        double xOffset = Math.cos(angle) * radius;
                        double zOffset = Math.sin(angle) * radius;
                        double yOffset = Math.random() * entityHeight;
                        serverLevel.method_14199(particle, entityPos.field_1352 + xOffset, entityPos.field_1351 + yOffset, entityPos.field_1350 + zOffset, 1, 0.0, 0.0, 0.0, 0.1);
                        ++i;
                    }
                } else {
                    MegaShowdown.LOGGER.error("Invalid Particle Revert used for pokemons: {}, particle id: {}", (Object)context.getPokemon().getSpecies().getName(), particle_revert);
                }
            });
        }
    }
}

