/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.AbstractStorageTerminalBlock;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.NetworkInventory;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.menu.StorageTerminalMenu;
import com.tom.storagemod.platform.PlatformBlockEntity;
import com.tom.storagemod.util.BeaconLevelCalc;
import com.tom.storagemod.util.PlayerInvUtil;
import com.tom.storagemod.util.TickerUtil;
import com.tom.storagemod.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_7225;

public class StorageTerminalBlockEntity
extends PlatformBlockEntity
implements class_3908,
TickerUtil.TickableServer {
    private NetworkInventory itemCache = new NetworkInventory();
    private Map<StoredItemStack, StoredItemStack> items = new HashMap<StoredItemStack, StoredItemStack>();
    private int sort;
    private int searchType;
    private int modes;
    private String lastSearch = "";
    private boolean updateItems;
    private int changeCount;
    private int beaconLevel;
    private long changeTracker;
    private int slotCount;
    private int freeCount;

    public StorageTerminalBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)Content.terminalBE.get(), pos, state);
    }

    public StorageTerminalBlockEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_11863.field_9236) {
            class_2680 st = this.field_11863.method_8320(this.field_11867);
            class_2350 d = (class_2350)st.method_11654((class_2769)AbstractStorageTerminalBlock.FACING);
            AbstractStorageTerminalBlock.TerminalPos p = (AbstractStorageTerminalBlock.TerminalPos)((Object)st.method_11654(AbstractStorageTerminalBlock.TERMINAL_POS));
            if (p == AbstractStorageTerminalBlock.TerminalPos.UP) {
                d = class_2350.field_11036;
            }
            if (p == AbstractStorageTerminalBlock.TerminalPos.DOWN) {
                d = class_2350.field_11033;
            }
            this.itemCache.onLoad(this.field_11863, this.field_11867.method_10093(d), d.method_10153(), this);
        }
    }

    public class_1703 createMenu(int id, class_1661 plInv, class_1657 arg2) {
        return new StorageTerminalMenu(id, plInv, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"menu.toms_storage.storage_terminal");
    }

    public Map<StoredItemStack, StoredItemStack> getStacks() {
        this.updateItems = true;
        return this.items;
    }

    public StoredItemStack pullStack(StoredItemStack stack, long max) {
        if (stack == null) {
            return null;
        }
        IInventoryAccess ii = this.itemCache.getAccess(this.field_11863, this.field_11867);
        class_1799 ex = ii.pullMatchingStack(stack.getStack(), max);
        if (ex.method_7960()) {
            return null;
        }
        return new StoredItemStack(ex);
    }

    public StoredItemStack pushStack(StoredItemStack stack) {
        if (stack == null) {
            return null;
        }
        IInventoryAccess ii = this.itemCache.getAccess(this.field_11863, this.field_11867);
        class_1799 r = ii.pushStack(stack.getActualStack());
        if (r.method_7960()) {
            return null;
        }
        return new StoredItemStack(r);
    }

    public class_1799 pushStack(class_1799 itemstack) {
        StoredItemStack is = this.pushStack(new StoredItemStack(itemstack));
        return is == null ? class_1799.field_8037 : is.getActualStack();
    }

    public void pushOrDrop(class_1799 st) {
        if (st.method_7960()) {
            return;
        }
        StoredItemStack st0 = this.pushStack(new StoredItemStack(st));
        if (st0 != null) {
            this.dropItem(st0.getActualStack());
        }
    }

    public void dropItem(class_1799 stack) {
        class_1264.method_5449((class_1937)this.field_11863, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), (class_1799)stack);
    }

    @Override
    public void updateServer() {
        if (this.updateItems) {
            IInventoryAccess ii = this.itemCache.getAccess(this.field_11863, this.field_11867);
            IInventoryAccess.IInventoryChangeTracker tr = ii.tracker();
            long ct = tr.getChangeTracker(this.field_11863);
            if (this.changeTracker != ct) {
                this.changeTracker = ct;
                if (Config.get().runMultithreaded) {
                    this.items = tr.streamWrappedStacks(true).collect(Collectors.groupingByConcurrent(Function.identity(), Util.reducingWithCopy(null, StoredItemStack::merge, StoredItemStack::new)));
                } else {
                    this.items = new HashMap<StoredItemStack, StoredItemStack>();
                    tr.streamWrappedStacks(false).forEach(s -> this.items.merge((StoredItemStack)s, (StoredItemStack)s, StoredItemStack::merge));
                    this.items.replaceAll((k, v) -> new StoredItemStack((StoredItemStack)v));
                }
                this.slotCount = class_3532.method_15340((int)ii.getSlotCount(), (int)0, (int)Short.MAX_VALUE);
                this.freeCount = class_3532.method_15340((int)ii.getFreeSlotCount(), (int)0, (int)Short.MAX_VALUE);
                ++this.changeCount;
            }
            this.updateItems = false;
        }
        if (this.field_11863.method_8510() % 40L == (long)(Math.abs(this.field_11867.hashCode()) % 40)) {
            this.beaconLevel = class_2338.method_29715((class_238)new class_238(this.field_11867).method_1014(8.0)).mapToInt(p -> {
                class_2680 st;
                if (this.field_11863.method_8477(p) && (st = this.field_11863.method_8320(p)).method_27852(class_2246.field_10327)) {
                    return BeaconLevelCalc.calcBeaconLevel(this.field_11863, p.method_10263(), p.method_10264(), p.method_10260());
                }
                return -1;
            }).max().orElse(-1);
        }
    }

    public boolean canInteractWith(class_1657 player, boolean menuCheck) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        int d = 6;
        int termReach = PlayerInvUtil.findItem(player, i -> i.method_7909() instanceof WirelessTerminal, 0, i -> ((WirelessTerminal)i.method_7909()).getRange(player, (class_1799)i));
        if (Config.get().wirelessTermBeaconLvl != -1 && this.beaconLevel >= Config.get().wirelessTermBeaconLvl && termReach > 0) {
            if (Config.get().wirelessTermBeaconLvlCrossDim != -1 && this.beaconLevel >= Config.get().wirelessTermBeaconLvlCrossDim) {
                return true;
            }
            return player.method_37908() == this.field_11863;
        }
        d = Math.max(d, termReach);
        if (menuCheck) {
            d += d / 4;
        }
        return player.method_37908() == this.field_11863 && !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > (double)(d * d));
    }

    public int getSorting() {
        return this.sort;
    }

    public int getModes() {
        return this.modes;
    }

    public int getSearchType() {
        return this.searchType;
    }

    public void setSorting(int newC) {
        this.sort = newC;
        this.method_5431();
    }

    public void setModes(int modes) {
        this.modes = modes;
        this.method_5431();
    }

    public void setSearchType(int searchType) {
        this.searchType = searchType;
        this.method_5431();
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11007(compound, provider);
        compound.method_10569("sorting", this.sort);
        compound.method_10569("modes", this.modes);
        compound.method_10569("searchType", this.searchType);
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 provider) {
        if (compound.method_10545("sort")) {
            int s = compound.method_10550("sort");
            int controllMode = s & 3;
            boolean rev = (s & 4) > 0;
            int type = (s & 0x18) >> 3;
            this.searchType = (s & 0xE0) >> 5;
            boolean ghostItems = (s & 0x200) != 0;
            boolean tallMode = (s & 0x400) != 0;
            boolean pullFromInv = (s & 0x100) != 0;
            this.modes = controllMode | (tallMode ? 16 : 0) | (pullFromInv ? 32 : 0);
            this.sort = type | (rev ? 256 : 0) | (ghostItems ? 512 : 0);
        } else {
            this.sort = compound.method_10550("sorting");
            this.modes = compound.method_10550("modes");
            this.searchType = compound.method_10550("searchType");
        }
        super.method_11014(compound, provider);
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public void setLastSearch(String string) {
        this.lastSearch = string;
    }

    public int getBeaconLevel() {
        return this.beaconLevel;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public int getFreeCount() {
        return this.freeCount;
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

