/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.api.MultiblockInventoryAPI;
import com.tom.storagemod.block.IInventoryNode;
import com.tom.storagemod.block.entity.IInventoryConnector;
import com.tom.storagemod.block.entity.InventoryInterfaceBlockEntity;
import com.tom.storagemod.inventory.BlockFilter;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IInventoryConnectorReference;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.inventory.MultiInventoryAccess;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.inventory.PlatformMultiInventoryAccess;
import com.tom.storagemod.platform.PlatformBlockEntity;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.InventoryConnectorConfigUtil;
import com.tom.storagemod.util.TickerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class InventoryConnectorBlockEntity
extends PlatformBlockEntity
implements TickerUtil.TickableServer,
IInventoryConnector,
IInventoryAccess.IInventory,
IInventoryConnectorReference {
    private MultiInventoryAccess handler = new PlatformMultiInventoryAccess();
    private Map<BlockFace, PlatformInventoryAccess.BlockInventoryAccess> invAccesses = new HashMap<BlockFace, PlatformInventoryAccess.BlockInventoryAccess>();
    private Set<IInventoryAccess> connectedInvs = new HashSet<IInventoryAccess>();
    private Set<IInventoryConnector> linkedConnectors = new HashSet<IInventoryConnector>();
    private Set<BlockFace> interfaces = new HashSet<BlockFace>();

    public InventoryConnectorBlockEntity(class_2338 p_155229_, class_2680 p_155230_) {
        super((class_2591)Content.connectorBE.get(), p_155229_, p_155230_);
    }

    @Override
    public void updateServer() {
        long time = this.field_11863.method_8510();
        if (time % 20L == (long)(Math.abs(this.field_11867.hashCode()) % 20)) {
            this.detectTouchingInventories();
            this.detectCableNetwork();
            this.handler.build(this, this.linkedConnectors);
        }
    }

    private void detectCableNetwork() {
        this.linkedConnectors.clear();
        Collection<class_2338> netBlocks = InventoryCableNetwork.getNetwork(this.field_11863).getNetworkNodes(this.field_11867);
        for (class_2338 p : netBlocks) {
            class_2586 be;
            if (!this.field_11863.method_8477(p) || (be = this.field_11863.method_8321(p)) == this || !(be instanceof IInventoryConnector)) continue;
            IInventoryConnector te = (IInventoryConnector)be;
            this.linkedConnectors.add(te);
        }
    }

    private void detectTouchingInventories() {
        BlockFilter connFilter = BlockFilter.getFilterAt(this.field_11863, this.field_11867);
        UnaryOperator wrapper = connFilter != null ? i -> connFilter.wrap(this.field_11863, (IInventoryAccess)i) : UnaryOperator.identity();
        this.connectedInvs.clear();
        HashMap<class_2338, class_2350> connected = new HashMap<class_2338, class_2350>();
        HashSet<BlockFilter> blockFilters = new HashSet<BlockFilter>();
        HashSet<BlockFace> interfaces = new HashSet<BlockFace>();
        Stack<class_2338> toCheck = new Stack<class_2338>();
        HashSet<class_2338> checkedBlocks = new HashSet<class_2338>();
        toCheck.add(this.field_11867);
        checkedBlocks.add(this.field_11867);
        int maxRange = Config.get().invConnectorScanRange;
        maxRange *= maxRange;
        boolean onlyTrims = Config.get().onlyTrims;
        Consumer<class_2338> mbCheck = opos -> {
            BlockFilter f = BlockFilter.getFilterAt(this.field_11863, opos);
            if (f != null) {
                blockFilters.add(f);
            }
            toCheck.add((class_2338)opos);
            checkedBlocks.add((class_2338)opos);
        };
        while (!toCheck.isEmpty()) {
            class_2338 cp = (class_2338)toCheck.pop();
            for (class_2350 d2 : class_2350.values()) {
                class_2338 p2 = cp.method_10093(d2);
                if (checkedBlocks.contains(p2) || !(p2.method_10262((class_2382)this.field_11867) < (double)maxRange)) continue;
                checkedBlocks.add(p2);
                class_2680 state = this.field_11863.method_8320(p2);
                if (state.method_26164(StorageTags.TRIMS)) {
                    toCheck.add(p2);
                    continue;
                }
                if (state.method_26204() instanceof IInventoryNode) {
                    interfaces.add(new BlockFace(p2, class_2350.field_11033));
                    toCheck.add(p2);
                    continue;
                }
                if (!InventoryConnectorConfigUtil.canConnect(state) || onlyTrims || !PlatformInventoryAccess.BlockInventoryAccess.hasInventoryAt(this.field_11863, p2, state, d2.method_10153())) continue;
                BlockFilter f2 = BlockFilter.getFilterAt(this.field_11863, p2);
                if (f2 != null) {
                    blockFilters.add(f2);
                }
                connected.put(p2, d2.method_10153());
                toCheck.add(p2);
                MultiblockInventoryAPI.EVENT.invoker().detectMultiblocks(this.field_11863, p2, state, mbCheck);
            }
        }
        blockFilters.forEach(f -> f.getConnectedBlocks().forEach(connected::remove));
        HashMap<BlockFace, PlatformInventoryAccess.BlockInventoryAccess> invA = new HashMap<BlockFace, PlatformInventoryAccess.BlockInventoryAccess>();
        connected.forEach((p, d) -> {
            BlockFace s = new BlockFace((class_2338)p, (class_2350)d);
            PlatformInventoryAccess.BlockInventoryAccess acc = this.invAccesses.remove(s);
            if (acc == null) {
                acc = new PlatformInventoryAccess.BlockInventoryAccess();
                acc.onLoad(this.field_11863, (class_2338)p, (class_2350)d, this);
            }
            invA.put(s, acc);
            this.connectedInvs.add((IInventoryAccess)wrapper.apply(acc));
        });
        blockFilters.forEach(f -> {
            if (f.skip()) {
                return;
            }
            BlockFace s = new BlockFace(f.getMainPos(), f.getSide());
            PlatformInventoryAccess.BlockInventoryAccess acc = this.invAccesses.remove(s);
            if (acc == null) {
                acc = new PlatformInventoryAccess.BlockInventoryAccess();
                acc.onLoad(this.field_11863, f.getMainPos(), f.getSide(), this);
            }
            invA.put(s, acc);
            this.connectedInvs.add((IInventoryAccess)wrapper.apply(f.wrap(this.field_11863, acc)));
        });
        this.invAccesses.values().forEach(IInventoryAccess::markInvalid);
        this.invAccesses.clear();
        this.invAccesses = invA;
        if (!this.interfaces.equals(interfaces)) {
            InventoryCableNetwork net = InventoryCableNetwork.getNetwork(this.field_11863);
            this.interfaces.forEach(net::markNodeInvalid);
            this.interfaces = interfaces;
            net.markNodeInvalid(this.field_11867);
        }
        for (BlockFace blockFace : this.interfaces) {
            class_2586 class_25862 = this.field_11863.method_8321(blockFace.pos());
            if (!(class_25862 instanceof InventoryInterfaceBlockEntity)) continue;
            InventoryInterfaceBlockEntity ii = (InventoryInterfaceBlockEntity)class_25862;
            ii.setConnectorAccess(this);
        }
    }

    public void method_11012() {
        super.method_11012();
        this.invAccesses.clear();
        this.handler.clear();
    }

    public UsageInfo getUsage() {
        return new UsageInfo(this.handler.getInventoryCount(), this.handler.getSlotCount(), this.handler.getFreeSlotCount());
    }

    @Override
    public IInventoryAccess getMergedHandler() {
        return this.handler;
    }

    public Set<IInventoryAccess> getConnectedInventories() {
        return this.connectedInvs;
    }

    public Set<BlockFace> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public boolean hasConnectedInventories() {
        return !this.method_11015();
    }

    @Override
    public IInventoryAccess getInventoryAccess() {
        return this.handler;
    }

    public List<class_2338> getConnectedBlocks() {
        return this.invAccesses.keySet().stream().map(b -> b.pos()).toList();
    }

    @Override
    public Collection<IInventoryConnector> getConnectedConnectors() {
        return this.linkedConnectors;
    }

    @Override
    public IInventoryConnector getConnectorRef() {
        return this;
    }

    public record UsageInfo(int blocks, int all, int free) {
    }
}

