/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.entity.PaintedBlockEntity;
import com.tom.storagemod.client.BakedPaintedModel;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.network.DataPacket;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.GameObject;
import com.tom.storagemod.polymorph.PolymorphTerminalWidget;
import com.tom.storagemod.screen.CraftingTerminalScreen;
import com.tom.storagemod.screen.FilingCabinetScreen;
import com.tom.storagemod.screen.InventoryConfiguratorScreen;
import com.tom.storagemod.screen.InventoryLinkScreen;
import com.tom.storagemod.screen.ItemFilterScreen;
import com.tom.storagemod.screen.LevelEmitterScreen;
import com.tom.storagemod.screen.StorageTerminalScreen;
import com.tom.storagemod.screen.TagItemFilterScreen;
import com.tom.storagemod.util.IDataReceiver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1091;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_773;

public class StorageModClient
implements ClientModInitializer {
    public static class_304 openTerm;

    public void onInitializeClient() {
        class_3929.method_17542(Content.storageTerminalMenu.get(), StorageTerminalScreen::new);
        class_3929.method_17542(Content.craftingTerminalMenu.get(), CraftingTerminalScreen::new);
        class_3929.method_17542(Content.invConfigMenu.get(), InventoryConfiguratorScreen::new);
        class_3929.method_17542(Content.levelEmitterMenu.get(), LevelEmitterScreen::new);
        class_3929.method_17542(Content.inventoryLink.get(), InventoryLinkScreen::new);
        class_3929.method_17542(Content.itemFilterMenu.get(), ItemFilterScreen::new);
        class_3929.method_17542(Content.tagItemFilterMenu.get(), TagItemFilterScreen::new);
        class_3929.method_17542(Content.filingCabinetMenu.get(), FilingCabinetScreen::new);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Content.paintedTrim.get(), class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Content.invCableFramed.get(), class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Content.levelEmitter.get(), class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Content.invCableConnectorFramed.get(), class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Content.invProxy.get(), class_1921.method_23583());
        ClientPlayNetworking.registerGlobalReceiver(DataPacket.ID, (p, c) -> {
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof IDataReceiver) {
                IDataReceiver d = (IDataReceiver)patt0$temp;
                d.receive(p.tag());
            }
        });
        ModelLoadingPlugin.register((ModelLoadingPlugin)new ModelLoadingPlugin(this){
            private Set<class_1091> locs = new HashSet<class_1091>();

            public void onInitializeModelLoader(ModelLoadingPlugin.Context ctx) {
                StorageModClient.bakeModels(this.locs);
                ctx.modifyModelAfterBake().register((p, c) -> {
                    if (this.locs.contains(c.topLevelId()) && !(p instanceof BakedPaintedModel)) {
                        return new BakedPaintedModel(p);
                    }
                    return p;
                });
            }
        });
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (world != null) {
                try {
                    class_2680 mimicBlock = ((PaintedBlockEntity)world.method_8321(pos)).getPaintedBlockState();
                    return class_310.method_1551().method_1505().method_1697(mimicBlock, world, pos, tintIndex);
                }
                catch (Exception var8) {
                    return -1;
                }
            }
            return -1;
        }, (Object[])new class_2248[]{(class_2248)Content.paintedTrim.get(), (class_2248)Content.invCableFramed.get(), (class_2248)Content.invCableConnectorFramed.get(), (class_2248)Content.invProxy.get()});
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ctx -> {
            class_4587 ps = new class_4587();
            ps.method_22903();
            ClientUtil.drawTerminalOutline(ps);
            ClientUtil.drawConfiguratorOutline(ps);
            ps.method_22909();
        });
        ClientLoginNetworking.registerGlobalReceiver((class_2960)StorageMod.id("config"), (mc, handler, buf, fc) -> {
            Config read;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteBufInputStream((ByteBuf)buf));){
                read = (Config)StorageMod.gson.fromJson((Reader)reader, Config.class);
            }
            catch (Exception e) {
                StorageMod.LOGGER.warn("Error loading server config", (Throwable)e);
                return CompletableFuture.completedFuture(null);
            }
            StorageMod.CONFIG = read;
            StorageMod.LOGGER.info("Received server config");
            return CompletableFuture.completedFuture(PacketByteBufs.empty());
        });
        openTerm = new class_304("key.toms_storage.open_terminal", 66, "key.categories.gameplay");
        KeyBindingHelper.registerKeyBinding((class_304)openTerm);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            if (openTerm.method_1436()) {
                NetworkHandler.openTerminal();
            }
        });
        ItemTooltipCallback.EVENT.register((s, t, c, l) -> ClientUtil.collectExtraTooltips(s, l));
        ClientLifecycleEvents.CLIENT_STARTED.register(mc -> mc.field_1705.field_47847.method_55810((gr, tr) -> ClientUtil.drawConfiguratorOverlay(gr)));
        if (StorageMod.polymorph) {
            PolymorphTerminalWidget.register();
        }
    }

    private static void bakeModels(Set<class_1091> locs) {
        StorageModClient.bindPaintedModel(locs, Content.paintedTrim);
        StorageModClient.bindPaintedModel(locs, Content.invCableFramed);
        StorageModClient.bindPaintedModel(locs, Content.invProxy);
        StorageModClient.bindPaintedModel(locs, Content.invCableConnectorFramed);
    }

    private static void bindPaintedModel(Set<class_1091> locs, GameObject<? extends class_2248> block) {
        class_2960 baseLoc = block.getId();
        block.get().method_9595().method_11662().forEach(st -> {
            class_1091 resLoc = class_773.method_3336((class_2960)baseLoc, (class_2680)st);
            locs.add(resLoc);
        });
    }
}

