/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LootTableScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BCA");
    private static final String OUTPUT_PATH = "logs/loot_scan_results.csv";

    public static void runScan() {
        File root = LootTableScanner.resolveRoot();
        if (root == null) {
            LOGGER.error("No valid structure folder found.");
            return;
        }
        ArrayList<File> nbtFiles = new ArrayList<File>();
        LootTableScanner.collectNbtFiles(root, nbtFiles);
        LinkedHashMap<File, Map<String, Integer>> perFileCounts = new LinkedHashMap<File, Map<String, Integer>>();
        TreeSet<String> allLootTables = new TreeSet<String>();
        for (File file : nbtFiles) {
            Map<String, Integer> lootCounts = LootTableScanner.countLootTables(file);
            perFileCounts.put(file, lootCounts);
            allLootTables.addAll(lootCounts.keySet());
        }
        LootTableScanner.writeResults(perFileCounts, allLootTables);
    }

    private static File resolveRoot() {
        String[] candidates;
        for (String path : candidates = new String[]{"../src/main/resources/data/bca/structure", "src/main/resources/data/bca/structure", "resources/data/bca/structure", "data/bca/structure"}) {
            File dir = new File(path);
            if (!dir.isDirectory()) continue;
            return dir;
        }
        return null;
    }

    private static void collectNbtFiles(File dir, List<File> list) {
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File f : children) {
            if (f.isDirectory()) {
                LootTableScanner.collectNbtFiles(f, list);
                continue;
            }
            if (!f.getName().endsWith(".nbt")) continue;
            list.add(f);
        }
    }

    private static Map<String, Integer> countLootTables(File file) {
        LinkedHashMap<String, Integer> lootCounts = new LinkedHashMap<String, Integer>();
        try (FileInputStream is = new FileInputStream(file);){
            class_2487 root = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
            class_2499 blocks = root.method_10554("blocks", 10);
            for (int i = 0; i < blocks.size(); ++i) {
                String loot;
                class_2487 blockNbt;
                String id;
                class_2487 block = blocks.method_10602(i);
                if (!block.method_10573("nbt", 10) || !"minecraft:chest".equals(id = (blockNbt = block.method_10562("nbt")).method_10558("id")) && !"minecraft:barrel".equals(id) || (loot = blockNbt.method_10558("LootTable")) == null || loot.isEmpty()) continue;
                lootCounts.merge(loot, 1, Integer::sum);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing {}: {}", (Object)file.getName(), (Object)e.getMessage());
        }
        return lootCounts;
    }

    private static void writeResults(Map<File, Map<String, Integer>> perFileCounts, Set<String> allLootTables) {
        File outFile = new File(OUTPUT_PATH);
        outFile.getParentFile().mkdirs();
        try (PrintWriter pw = new PrintWriter(new FileWriter(outFile));){
            pw.print("File");
            for (String string : allLootTables) {
                pw.print("\t" + LootTableScanner.formatLootName(string));
            }
            pw.println();
            for (Map.Entry entry : perFileCounts.entrySet()) {
                String name = LootTableScanner.formatDisplayName(((File)entry.getKey()).getName());
                pw.print(name);
                for (String lootId : allLootTables) {
                    int count = ((Map)entry.getValue()).getOrDefault(lootId, 0);
                    pw.print("\t" + count);
                }
                pw.println();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error writing Loot Scan Results file: {}", (Object)e.getMessage());
        }
        LOGGER.info("Loot Scan Results written to {}", (Object)outFile.getAbsolutePath());
    }

    private static String formatLootName(String lootId) {
        String base = lootId.substring(lootId.lastIndexOf(47) + 1).replace('_', ' ').replace('-', ' ');
        return LootTableScanner.capitalizeWords(base);
    }

    private static String formatDisplayName(String filename) {
        String base = filename.replaceFirst("\\.nbt$", "").replace('_', ' ').replace('-', ' ');
        return LootTableScanner.capitalizeWords(base);
    }

    private static String capitalizeWords(String input) {
        StringBuilder sb = new StringBuilder();
        for (String part : input.split("\\s+")) {
            if (part.isEmpty()) continue;
            sb.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1).toLowerCase()).append(' ');
        }
        return sb.toString().trim();
    }
}

