/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ItemCategorizer {
    private static final String OUTPUT_PATH = "logs/itemCategories.txt";
    private static final List<Object> ADMIN_ITEMS = List.of("mine.*:air", "barrier", ":light|", "command_block", "jigsaw", "structure", "spawn_egg", "spawner", "bedrock", "debug");
    private static final List<String> BAD_DECOR = List.of("gate", "_fence", "door", "brick", "slab", "stair", "sign", "pressure_plate", "corn_button", "mine.*button", "banner", "wall", "mine.*terracotta", "concrete", "candle", "shulker_box", "sleeping_bag", "mine.*glass", "portstone", "sharestone", "chest|", "chest_", "waxed", "exposed", "infested", "oxidized", "weathered", "chiseled", "mine.*cracked", "polished", "cobble.*smooth_b", "cobble.*smooth_s", "cobble.*smooth_t", "mine.*smooth", "stripped", "warped_f.*stick", "warped_n", "warped_r", "nylium", "crimson_roots", "cut_", "sherd", "cobble.*stone_block|", "mine.*block|", "sculk", "carpet", "budding", "cluster", "bars", "grate", "grass|", "slathered", "grain_bale", "saccharine_button");
    private static final List<String> BAD_ITEMS = List.of(":waystone", "_waystone", "coral", "minecart", "rail", "leaves", "turtle_egg", "turtle_scute", "horse_armor", "saddle", "_wood", "dye", "mint_seed", "warp_dust", "warp_plate", "warp_stone", "boat", "feather|", "mint|", "power_a", "power_b", "power_l", "power_w", "_bud", "xp_bucket", "vault", "wolf_armor", "purpur_pillar", "farmland", "netherrack", "suspicious_sand", "dirt_path", "deepslate_tiles", "cod_bucket", "salmon_bucket", "fish_bucket", "knowledge_book", "written_book", "beehive", "bee_nest", "bamboo_raft", "lava_bucket", "_bed", "reinforced_deepslate", "infinity_upgrade", "tatami");
    private static final List<Object> UTILITY_ITEMS = List.of("anvil|", "furnace|", "smoker|", "_stand", "_table", "t:stonecutter", "grindstone", "loom", "lectern", "cauldron", "barrel", "analyzer");
    private static final List<Object> DECORATIONS = List.of("painting", "item_frame", "flower_pot", "t:bookshelf", "mine.*bell", "campfire");
    private static final List<String> BUILDING_AND_UTILITY = List.of("beacon", "mine.*jukebox", "composter", "conduit", "respawn_anchor", "end_portal_frame", "crafter", "monitor", "pc", "healing_machine", "restoration_tank", "pasture", "display_case", "suspicious_gravel", "o_lantern");
    private static final List<String> MOB_DROPS_MISC = List.of("ender_pearl", "ender_eye", "_skull", "_head", "sniffer_egg", "rabbit_hide", "mine.*e_rod", ":end_rod", "lightning", "rabbit_foot");
    private static final List<String> OTHER = List.of("pokemon_model", "bundle", "filled_map", "firework", "tnt", "frogspawn", "glow_lichen", "shroomlight", "soul_soil", "decorated_pot");
    private static final List<Object> FIRST_REMOVE = List.of(new NamedList("ADMIN_ITEMS", ADMIN_ITEMS), new NamedList("BAD_DECOR", BAD_DECOR), new NamedList("BAD_ITEMS", BAD_ITEMS), new NamedList("UTILITY_ITEMS", UTILITY_ITEMS), new NamedList("DECORATIONS", DECORATIONS), new NamedList("BUILDING_AND_UTILITY", BUILDING_AND_UTILITY), new NamedList("MOB_DROPS_MISC", MOB_DROPS_MISC), new NamedList("OTHER", OTHER));
    private static final List<Object> Armor = List.of("mine.*boot", "chestplate", "mine.*helmet", "legging");
    private static final List<Object> Armor_Set = List.of(new NamedList("Armor", Armor));
    private static final List<Object> Weapons = List.of("sword", "bow|", "arrow", "trident", ":shield", "mace");
    private static final List<Object> Weapon_Set = List.of(new NamedList("Weapons", Weapons));
    private static final List<Object> Tools = List.of("_axe", "hoe", "pickaxe", "shovel", "shears", "flint_and_steel", "brush", "chain", "clock", ":compass", "lead|", "map");
    private static final List<Object> Tool_Set = List.of(new NamedList("Tools", Tools));
    private static final List<Object> Poke_Gear = List.of("fishingnav", "pokedex", "pokefinder", "pokenav", "pokestaff");
    private static final List<Object> Poke_Gear_Set = List.of(new NamedList("Poke_Gear", Poke_Gear));
    private static final List<Object> STAT_BOOSTERS = List.of("hp_up", "protein", "n:iron|", "calcium", "zinc", "carbos", "pp_");
    private static final List<Object> HELD_ITEMS = List.of("ability_shield", "absorb_bulb", "air_balloon", "assault_vest", "big_root", "binding_band", "black_sludge", "blunder_policy", "bright_powder", "cell_battery", "choice_band", "choice_scarf", "choice_specs", "cleanse_tag", "covert_cloak", "damp_rock", "destiny_knot", "eject_button", "eject_pack", "everstone", "eviolite", "expert_belt", "exp_share", "flame_orb", "float_stone", "focus_band", "focus_sash", "heat_rock", "heavy_duty_boots", "icy_rock", "iron_ball", "leftovers", "life_orb", "light_ball", "light_clay", "loaded_dice", "lucky_egg", "medicinal_leek", "mental_herb", "metal_powder", "metronome", "mirror_herb", "muscle_band", "power_herb", "protective_pads", "punching_glove", "quick_claw", "quick_powder", "red_card", "ring_target", "rocky_helmet", "room_service", "safety_goggles", "scope_lens", "shed_shell", "shell_bell", "smoke_ball", "smooth_rock", "soothe_bell", "sticky_barb", "terrain_extender", "throat_spray", "toxic_orb", "utility_umbrella", "weakness_policy", "white_herb", "wide_lens", "wise_glasses", "zoom_lens");
    private static final List<Object> TYPE_BOOSTING_ITEMS = List.of("black_belt", "black_glasses", "charcoal_stick", "dragon_fang", "hard_stone", "magnet|", "miracle_seed", "mystic_water", "never_melt_ice", "poison_barb", "sharp_beak", "silk_scarf", "silver_powder", "soft_sand", "spell_tag", "twisted_spoon");
    private static final List<Object> BATTLE_CONSUMABLES = List.of("elixir", "cobble.*ether|", ":x_", "dire_hit", "guard_spec");
    private static final List<Object> Combat = List.of(new NamedList("STAT_BOOSTERS", STAT_BOOSTERS), new NamedList("HELD_ITEMS", HELD_ITEMS), new NamedList("TYPE_BOOSTING_ITEMS", TYPE_BOOSTING_ITEMS), new NamedList("BATTLE_CONSUMABLES", BATTLE_CONSUMABLES));
    private static final List<Object> Poke_Balls = List.of("ancient.*ball", "cobble.*ball|");
    private static final List<Object> Poke_Balls_Set = List.of(new NamedList("Poke_Balls", Poke_Balls));
    private static final List<Object> Poke_Rods = List.of("ancient.*rod", "cobble.*rod|", "fishing.*rod");
    private static final List<Object> Poke_Rods_Set = List.of(new NamedList("Poke_Rods", Poke_Rods));
    private static final List<Object> Upgrades = List.of("travel.*upgrade", "pack.*upgrade", "pack.*downgrade");
    private static final List<Object> Upgrades_Set = List.of(new NamedList("Upgrades", Upgrades));
    private static final List<Object> Backpacks = List.of("travelersbackpack", "soph.*backpack");
    private static final List<Object> Backpacks_Set = List.of(new NamedList("Backpacks", Backpacks));
    private static final List<Object> NORMAL_BERRIES = List.of("oran_berry", "cheri_berry", "chesto_berry", "pecha_berry", "rawst_berry", "aspear_berry", "persim_berry", "razz_berry", "bluk_berry", "nanab_berry", "wepear_berry", "pinap_berry", "occa_berry", "passho_berry", "wacan_berry", "rindo_berry", "yache_berry", "chople_berry", "kebia_berry", "shuca_berry", "coba_berry", "payapa_berry", "tanga_berry", "charti_berry", "kasib_berry", "haban_berry", "colbur_berry", "babiri_berry", "chilan_berry", "roseli_berry");
    private static final List<Object> MUTATED_BERRIES = List.of("leppa_berry", "lum_berry", "hopo_berry", "figy_berry", "iapapa_berry", "wiki_berry", "aguav_berry", "mago_berry", "sitrus_berry", "touga_berry", "cornn_berry", "magost_berry", "rabuta_berry", "nomel_berry", "spelon_berry", "pamtre_berry", "watmel_berry", "durin_berry", "belue_berry", "enigma_berry", "kee_berry", "maranga_berry", "pomeg_berry", "kelpsy_berry", "qualot_berry", "hondew_berry", "grepa_berry", "tamato_berry", "liechi_berry", "ganlon_berry", "petaya_berry", "apicot_berry", "salac_berry", "starf_berry", "lansat_berry", "micle_berry", "custap_berry", "jaboca_berry", "rowap_berry");
    private static final List<Object> Berries = List.of(new NamedList("NORMAL_BERRIES", NORMAL_BERRIES), new NamedList("MUTATED_BERRIES", MUTATED_BERRIES));
    private static final List<String> SPECIAL_RARE_ITEMS = List.of("elytra", "totem_of_undying", "trial_key", "wind_charge", "heavy_core", "name_tag", "recovery_compass", "filled_map", "experience_bottle", "nether_star", "end_crystal", "bulb", "armadillo_scute", "goat_horn", "shulker_shell", "ability", "candy", "gem", "fossil|", "fossilized", "disc_", "mine.*dragon", "nautilus_shell", "heart_of_the_sea", "axolotl_bucket", "tadpole_bucket");
    private static final List<Object> Special = List.of(new NamedList("SPECIAL_RARE_ITEMS", SPECIAL_RARE_ITEMS));
    private static final List<Object> HEALING_HERBS = List.of("energy_root", "heal_powder", "revival_herb", "mint_leaf");
    private static final List<Object> MEDICINAL_ITEMS = List.of("remedy", "fine_remedy", "superb_remedy", "medicinal_brew", "pep_up_flower", "cobble.*potion", "antidote", "awakening", "_heal", "full_restore", "revive");
    private static final List<Object> Medicinal = List.of(new NamedList("HEALING_HERBS", HEALING_HERBS), new NamedList("MEDICINAL_ITEMS", MEDICINAL_ITEMS));
    private static final List<Object> EVOLUTION_ITEMS = List.of("auspicious_armor", "black_augurite", "chipped_pot", "cracked_pot", "deep_sea_scale", "deep_sea_tooth", "dragon_scale", "dubious_disc", "electirizer", "galarica_cuff", "galarica_wreath", "kings_rock", "link_cable", "magmarizer", "malicious_armor", "masterpiece_teacup", "metal_coat", "oval_stone", "peat_block", "prism_scale", "protector", "razor_claw", "razor_fang", "reaper_cloth", "sachet", "shell_helmet", "sweet", "tart_apple", "unremarkable_teacup", ":upgrade|", "whipped_dream");
    private static final List<Object> Evolution_Stones = List.of("cobble.*_stone|");
    private static final List<Object> Evolution = List.of(new NamedList("EVOLUTION_ITEMS", EVOLUTION_ITEMS), new NamedList("Evolution_Stones", Evolution_Stones));
    private static final List<Object> Relic = List.of("relic");
    private static final List<Object> Poke_Currency = List.of(new NamedList("Relic", Relic));
    private static final List<Object> Apricorn = List.of("_apricorn_seed", "_apricorn|");
    private static final List<Object> Apricorn_Set = List.of(new NamedList("Apricorn", Apricorn));
    private static final List<Object> Workshop = List.of("smithing_template", "plank", "ladder", "scaffolding", "froglight", "sponge", "log", "shard", "prismarine", ":bucket", "leather");
    private static final List<Object> Workshop_Set = List.of(new NamedList("Workshop", Workshop));
    private static final List<Object> Sittingroom = List.of("wool", "scroll", "string", "paper", "book");
    private static final List<Object> Sittingroom_Set = List.of(new NamedList("Sittingroom", Sittingroom));
    private static final List<String> BREWING_AND_ALCHEMY = List.of("blaze_powder", "ghast_tear", "phantom_membrane", "rabbit_foot", "spider_eye", "magma_cream", "nether_wart", "glass_bottle", "ominous_bottle", "mine.*potion");
    private static final List<Object> Potions = List.of(new NamedList("BREWING_AND_ALCHEMY", BREWING_AND_ALCHEMY));
    private static final List<String> FOOD_AND_CROPS = List.of("apple", "poisonous", ":potato|", "carrot", "beetroot|", "melon|", "melon_slice", "pumpkin|", "pumpkin_pie", "wheat|", "bread", "cookie", "cake", "glow_berries", ":chorus_fruit", "dried_kelp", ":vivichoke|");
    private static final List<Object> FOOD_ITEMS = List.of("berry_juice", "roasted_leek", "cooked", "braised", "dip", "_stew", "_soup", "baked_", "popped", "rotten_flesh", "bowl", "water_bucket", "milk_bucket");
    private static final List<Object> Fridge = List.of(new NamedList("FOOD_AND_CROPS", FOOD_AND_CROPS), new NamedList("FOOD_ITEMS", FOOD_ITEMS));
    private static final List<Object> Ice_Chest = List.of("rabbit", ":mutton", ":porkchop", ":chicken", ":beef", ":egg", "mine.*ice", "snow");
    private static final List<Object> Fish = List.of("cod", "salmon", "pufferfish", "tropical_fish");
    private static final List<Object> Freezer = List.of(new NamedList("Ice_Chest", Ice_Chest), new NamedList("Fish", Fish));
    private static final List<Object> Scraps = List.of("cobweb", "mine.*:stick|");
    private static final List<Object> Scrap_Set = List.of(new NamedList("Scraps", Scraps));
    private static final List<Object> REDSTONE_TECH = List.of("comparator", "repeater", "observer", "piston", ":lever", "tripwire_hook", "target", "daylight_detector", "redstone|", "lodestone", "hopper", "dispenser", "dropper", "lamp", "lantern", "torch|", "fire_charge", "gunpowder", "slime_ball");
    private static final List<Object> Redstone = List.of(new NamedList("REDSTONE_TECH", REDSTONE_TECH));
    private static final List<Object> TERRAIN = List.of("ingot", "_ore", "nugget", "diamond", "netherite", "quartz", "ancient", "coal", "emerald|", "lapis_lazuli", "flint", "andesite", "diorite", "granite", "stone", "sand|", "dirt", "podzol", "mycelium", "deepslate", "tuff", "basalt", "calcite", "obsidian", "clay", "mud|", "gravel", "raw_");
    private static final List<Object> Miner = List.of(new NamedList("TERRAIN", TERRAIN));
    private static final List<Object> PLANT_ITEMS = List.of("allium", "bluet", "orchid", "cornflower", "daisy", "poppy", "_rose|", ":rose_", "sunflower", "lilac", "peony", "petals", "torchflower", "tulip", "_seed");
    private static final List<String> PLANT_NATURE_BLOCKS = List.of("azalea", "dandelion", "lily_of_the_valley", "fern", "vine", "sea_pickle", "spore_blossom", "mangrove", "nether_sprouts", "crimson", "warped_f", "warped_h", "warped_s", "chorus", "mushroom", "pitcher", "cactus", "dead_bush", "dripleaf", "bamboo", "crimson_stem", "crimson_hyphae", "mushroom_stem");
    private static final List<String> NATURAL_MATERIALS_MISC = List.of("cocoa_beans", "hanging_roots", "kelp", "lily_pad", "sapling", "mulch", "bone", "honeycomb", "honey_bottle", "ink_sac", "sugar");
    private static final List<Object> Gardening = List.of(new NamedList("PLANT_ITEMS", PLANT_ITEMS), new NamedList("PLANT_NATURE_BLOCKS", PLANT_NATURE_BLOCKS), new NamedList("NATURAL_MATERIALS_MISC", NATURAL_MATERIALS_MISC));

    public static void run() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(OUTPUT_PATH));){
            List allItems = class_7923.field_41178.method_10235().stream().map(class_2960::toString).sorted().collect(Collectors.toCollection(ArrayList::new));
            ItemCategorizer.dumpAllItems(allItems, writer, "All Items", false);
            ItemCategorizer.dumpByKeywordList("First Removal", FIRST_REMOVE, allItems, writer, true, false, false);
            ItemCategorizer.dumpByKeywordList("Armor_Set", Armor_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Weapon_Set", Weapon_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Tool_Set", Tool_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Poke_Gear_Set", Poke_Gear_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Combat", Combat, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Poke_Balls_Set", Poke_Balls_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Poke_Rods_Set", Poke_Rods_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Upgrades_Set", Upgrades_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Backpacks_Set", Backpacks_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Berries", Berries, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Special", Special, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Medicinal", Medicinal, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Evolution", Evolution, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Poke_Currency", Poke_Currency, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Apricorn_Set", Apricorn_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Workshop_Set", Workshop_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Sittingroom_Set", Sittingroom_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Potions", Potions, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Fridge", Fridge, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Freezer", Freezer, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Scrap_Set", Scrap_Set, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Redstone", Redstone, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Miner", Miner, allItems, writer, true, true, true);
            ItemCategorizer.dumpByKeywordList("Gardening", Gardening, allItems, writer, true, true, true);
            ItemCategorizer.dumpAllItems(allItems, writer, "Remaining Items", true);
            writer.write("=== End of categorized dump ===\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeLootTableJson(String categoryName, List<String> items) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:chest");
        JsonObject pool = new JsonObject();
        pool.addProperty("rolls", (Number)1);
        JsonArray entries = new JsonArray();
        for (String item : items) {
            JsonObject entry = new JsonObject();
            entry.addProperty("type", "item");
            entry.addProperty("name", item);
            entry.addProperty("weight", (Number)1);
            entries.add((JsonElement)entry);
        }
        pool.add("entries", (JsonElement)entries);
        JsonArray pools = new JsonArray();
        pools.add((JsonElement)pool);
        root.add("pools", (JsonElement)pools);
        try {
            Path dir = Path.of("logs/support_tables", new String[0]);
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(categoryName.toLowerCase().replaceAll("[^a-z0-9._-]", "_") + ".json");
            try (FileWriter fw = new FileWriter(file.toFile());){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root, (Appendable)fw);
            }
            System.out.println("Wrote loot table: " + String.valueOf(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean matchesKeyword(String id, String keyword) {
        String core;
        boolean hasWildcard = keyword.contains(".*");
        boolean hasSuffixAnchor = keyword.endsWith("|");
        String string = core = hasSuffixAnchor ? keyword.substring(0, keyword.length() - 1) : keyword;
        if (hasWildcard || hasSuffixAnchor) {
            Object regex = hasWildcard ? core : ".*" + Pattern.quote(core);
            if (hasSuffixAnchor) {
                regex = (String)regex + "$";
                return Pattern.compile((String)regex).matcher(id).matches();
            }
            return Pattern.compile((String)regex).matcher(id).find();
        }
        return id.contains(keyword);
    }

    private static List<String> flattenKeywords(Collection<?> keywords) {
        ArrayList<String> flat = new ArrayList<String>();
        for (Object obj : keywords) {
            if (obj instanceof String) {
                String s = (String)obj;
                flat.add(s);
                continue;
            }
            if (obj instanceof NamedList) {
                NamedList nl = (NamedList)obj;
                flat.addAll(ItemCategorizer.flattenKeywords(nl.items()));
                continue;
            }
            if (!(obj instanceof Collection)) continue;
            Collection nested = (Collection)obj;
            flat.addAll(ItemCategorizer.flattenKeywords(nested));
        }
        return flat;
    }

    private static void dumpByKeywordList(String header, Collection<?> keywords, List<String> remaining, BufferedWriter writer, boolean removeAfter, boolean printItems, boolean writeTables) throws IOException {
        if (writeTables) {
            writer.write("=== " + header + " ===\n");
        }
        LinkedHashMap<String, List<String>> table = new LinkedHashMap<String, List<String>>();
        for (Object obj : keywords) {
            if (obj instanceof String) {
                String keyword = (String)obj;
                List<String> matches = remaining.stream().filter(id -> ItemCategorizer.matchesKeyword(id, keyword)).toList();
                if (removeAfter) {
                    remaining.removeAll(matches);
                }
                table.put(keyword, matches);
                if (!printItems || matches.isEmpty()) continue;
                ItemCategorizer.writeLootTableJson(keyword, matches);
                continue;
            }
            if (!(obj instanceof NamedList)) continue;
            NamedList nl = (NamedList)obj;
            List<String> flat = ItemCategorizer.flattenKeywords(nl.items());
            ArrayList<String> allMatches = new ArrayList<String>();
            for (String keyword : flat) {
                List<String> matches = remaining.stream().filter(id -> ItemCategorizer.matchesKeyword(id, keyword)).toList();
                if (removeAfter) {
                    remaining.removeAll(matches);
                }
                allMatches.addAll(matches);
                if (!printItems || matches.isEmpty()) continue;
                ItemCategorizer.writeLootTableJson(nl.name(), matches);
            }
            table.put(nl.name(), allMatches);
        }
        if (writeTables) {
            ArrayList headers = new ArrayList(table.keySet());
            writer.write(String.join((CharSequence)"\t", headers) + "\n");
            int max = table.values().stream().mapToInt(List::size).max().orElse(0);
            for (int i = 0; i < max; ++i) {
                ArrayList<String> cells = new ArrayList<String>(headers.size());
                for (String col : headers) {
                    List list = (List)table.get(col);
                    cells.add(i < list.size() ? (String)list.get(i) : "");
                }
                writer.write(String.join((CharSequence)"\t", cells) + "\n");
            }
            writer.write("=== End of " + header + " ===\n\n");
        }
    }

    private static void dumpAllItems(List<String> items, BufferedWriter writer, String header, boolean printItems) throws IOException {
        writer.write("=== " + header + " (" + items.size() + " total) ===\n");
        if (printItems) {
            for (String item : items) {
                writer.write(item + "\n");
            }
        }
        writer.write("=== End of " + header + " ===\n\n");
    }

    record NamedList(String name, Collection<?> items) {
    }
}

