/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.strikeknight57.bca.CobblemonAdditions;
import io.strikeknight57.bca.config.ConfigData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public final class Config {
    private static final Logger LOGGER = CobblemonAdditions.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("cobblemon-additions");
    private static final Path CONFIG_PATH = CONFIG_DIR.resolve("cobblemon-additions.json");
    public static final Map<String, String> compatOverrides = new HashMap<String, String>();
    public static boolean enableLootScan = false;
    public static boolean enableItemScan = false;
    public static double lootRollMultiplierPercent = 100.0;
    public static final Map<String, JsonArray> lootWeights = new HashMap<String, JsonArray>();

    private Config() {
    }

    public static void init() {
        Config.ensureConfigDir();
        JsonObject root = Config.loadRoot();
        JsonObject compat = Config.getObject(root, "modCompatibility");
        Config.ensureDefaults(compat);
        compatOverrides.clear();
        for (Map.Entry e : compat.entrySet()) {
            compatOverrides.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
        }
        root.add("modCompatibility", (JsonElement)compat);
        JsonObject developer = Config.getObject(root, "developerSettings");
        enableLootScan = Config.readBoolean(developer, "enableLootScan", enableLootScan);
        enableItemScan = Config.readBoolean(developer, "enableItemScan", enableItemScan);
        root.add("developerSettings", (JsonElement)developer);
        JsonObject loot = Config.getObject(root, "lootMultiplier");
        lootRollMultiplierPercent = Config.readDouble(loot, "lootRollMultiplierPercent", lootRollMultiplierPercent, 0.0);
        root.add("lootMultiplier", (JsonElement)loot);
        JsonObject defaults = ConfigData.defaultLootWeights();
        lootWeights.clear();
        for (Map.Entry e : defaults.entrySet()) {
            if (!((JsonElement)e.getValue()).isJsonArray()) continue;
            lootWeights.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonArray());
        }
        Config.saveRoot(root);
    }

    private static void ensureConfigDir() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to create config directory: {}", (Object)CONFIG_DIR, (Object)ex);
        }
    }

    private static JsonObject loadRoot() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return JsonParser.parseString((String)json).getAsJsonObject();
            }
            catch (JsonParseException | IOException ex) {
                LOGGER.error("Failed to read/parse config file, using empty root", ex);
            }
        }
        return new JsonObject();
    }

    private static void saveRoot(JsonObject root) {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to save config file", (Throwable)ex);
        }
    }

    private static JsonObject getObject(JsonObject parent, String key) {
        return parent.has(key) && parent.get(key).isJsonObject() ? parent.getAsJsonObject(key) : new JsonObject();
    }

    private static boolean readBoolean(JsonObject obj, String key, boolean defaultVal) {
        if (obj.has(key) && obj.get(key).isJsonPrimitive()) {
            try {
                return obj.get(key).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        obj.addProperty(key, Boolean.valueOf(defaultVal));
        return defaultVal;
    }

    private static double readDouble(JsonObject obj, String key, double defaultVal, double min) {
        if (obj.has(key) && obj.get(key).isJsonPrimitive()) {
            try {
                double v = obj.get(key).getAsDouble();
                return v < min ? min : v;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        obj.addProperty(key, (Number)defaultVal);
        return defaultVal;
    }

    private static void ensureDefaults(JsonObject compatObj) {
        for (String modId : ConfigData.DEFAULT_MODS) {
            if (compatObj.has(modId)) continue;
            compatObj.addProperty(modId, "");
        }
    }
}

